<?php

$d = dirname(__FILE__) . '/';

if(!defined('ROOT_DIR'))
	define('ROOT_DIR', dirname(__FILE__) . '/');


include_once($d . 'confs/_config_project.php');

if(!defined('VERSION'))
	define('VERSION', '0.0.01');

if(!defined('PROJECT_SITE_URL'))
	define('PROJECT_SITE_URL', 'https://ihome.net2me.pl/raspberry-ihome-controler/');

$is_ip_ok1 = fnct :: get_arr($_SERVER, 'SERVER_ADMIN', '-1') == 'ihome@localhost';
$is_ip_ok2 = fnct :: get_arr($_SERVER, 'DOCUMENT_ROOT', '') == 'W:/_apache_files';

if(($ip_update = fnct :: get_arr($_GET, 'ip_update', '')) > '' && ($is_ip_ok1 | $is_ip_ok2))
	$host = 'http://' . $ip_update . '/ihome-raspberry/?update=1';
else
	$host = PROJECT_SITE_URL . '?update=' . VERSION;

$str = file_get_contents($host);

if(isset($argv) && is_array($argv) && count($argv) >= 1)
	$A = $argv[1];
else
	$A = false;

if(strlen($str) > 100)
{
	$dir = $d . '_tmp_update/';
	@mkdir($dir);

	$zipFile = $dir . '_update_.zip';
	
	file_put_contents($zipFile, $str);

	$zip = new ZipArchive;
	
	if ($zip -> open($zipFile) === true)
	{
		$zip -> extractTo($d, '_2doactions_before.php');

		if(file_exists($d . '_2doactions_before.php'))
			include_once($d . '_2doactions_before.php');

		$zip -> extractTo($d);
		$zip -> close();

		if(file_exists($d . '_2doactions_before.php'))
			unlink($d . '_2doactions_before.php');
		
		unlink($zipFile);
		rmdir($dir);

		$act = fnct :: getDir($d);

		foreach($act as $v)
			chmod($v, 0777);

		if(file_exists($d . '_2doactions_after.php'))
		{
			include_once($d . '_2doactions_after.php');
			unlink($d . '_2doactions_after.php');
		}

		$s = '<table>';
		$ou = array();
		foreach($act as $v)
		{
			if(file_exists($v) && strpos($v, '/data/') == 0 && strpos($v, '/confs/') == 0 && strpos($v, '___ram') == 0 && strpos($v, '_pycache_') == 0)
			{
				$dt = filemtime($v);
				$dts = date ("Y-m-d H:i:s", $dt);
				$r = fnct :: diff_str($dt, true);
				$s .= '<tr><td>'.$v.'</td><td>'.$dts.'</td><td>'.($r === true? '-ok-' : '').'</td></tr>';
				$ou[] = array('name' => $v, 'is_dir' => is_dir($v), 'date' => $dts, 'time_diff' => $r, 'ok' => $r === true);
			}
		}
		
		$s .= '</table>';

		// file_put_contents($d . 'data/log_update.html', $s);
		file_put_contents($d . 'data/log_update.json', json_encode($ou));

		if($A == 'mqtt')
			exit('ok');
		else
			fnct :: msg('ok', $s);
	}
	else
	{
		fnct :: msg('failed  (zip)');
	}
}
else
	fnct :: msg('no update - ' . $str);


class fnct
{
	public static function get_arr($o, $k, $n = false, $len = false)
	{		
		return (is_array($o) && array_key_exists($k, $o))? ($len? ($o[$k] > ''? $o[$k] : $n) : $o[$k]) : $n ;
	}

	public static function msg($str, $str1='')
	{
		if(isset($_GET['back2']))
		{
			header('Location: ' . $_GET['back2']);
		}
		else
		{
			if($str1)
				exit('<div style="text-align:center;">'.$str.'</div><div style="margin-top:50px;">'.$str1.'</div>');
			else
				exit($str);
		}
	}

	public static function getDir($dir, $init = true)
	{
		static $obj = array();
		
		if($init)
			$obj = array();
		
		if(!$handle = @opendir($dir))
			return $obj;

		while($file = @readdir($handle))
		{ 
			if($file != "." && $file != "..")
			{
				if(is_dir($dir.$file))
				{
					$obj[] = $dir.$file.'/';
					self :: getDir($dir.$file."/", false);
				}
				else
				{
					$obj[] = $dir.$file;
				}
			}
		}

		closedir($handle); 
	
		return $obj;
	}

	public static function diff_str($d, $nx = false)
	{
		$t = time();
		$n = $d;//strtotime($d);		

		$r = $t-$n;

		if($r < 60 || $t == $n)
			return $nx? true : 'mniej niż mintę';
		else if($r < 3600+1800)
			return round($r/60).' minut temu';
		else if($r < 3600*24)
			return round($r/3600).' godzin temu';
		else
			return round($r/(3600*24)).' dni temu';	
	}

}

?>