import os
import sys
import time
import json
ROOT_DIR = os.path.abspath(os.path.join(os.path.dirname( __file__ ), '..'))+"/"
sys.path.append(ROOT_DIR + 'pt/')
from lib.mqtt_class import mqttBroker
from read_write import sendCommand2Element, readAllElements
from _config_top import *
SQL = msqlLite(SQL_PATH)
SQL_REPLY = msqlLite(SQL_PATH, 'reply')
DATA_VAR = {}
DATA_OBJ = {}
DATA_MEM = {}
mqttObj = False
mqttConnStr = '';
errDevices = connErr(3)#15 minuty, bo iteracje co 5 min
def setInitialDataZigbee(is_start = False):
 global FILE_CONFIG, DATA_VAR, DATA_OBJ
 global errDevices
 config_obj_zg = json_file_get_var(FILE_CONFIG, 'zigbee')
 DATA_OBJ = {}
 for a in config_obj_zg:
  n = a['nazwa']
  if var_get_int(a, 'aktywny') == 1:
   DATA_OBJ[n] = a
   if a['typ'] == 'pk':
    errDevices.addDevice(n, var_get_len(a, 'opis', n))
   elif a['typ'] == 'sensor':
    errDevices.addDevice(n, var_get_len(a, 'opis', n), 12 * 4)#4 godziny
   if is_start == True:
    DATA_VAR[n] = ''			
  else:
   if n in DATA_VAR:
    del DATA_VAR[n]
   errDevices.removeDevice(n)
def check2do():
 global errDevices
 dx2do = SQL.getValues('zigbee_cmd')
 if len(dx2do) > 0:
  _k, _v = dx2do.popitem()
  oc = obj.get_by_val(DATA_OBJ, 'nazwa', _k, False)
  if oc != False:
   if oc['typ'] == 'pk':
    if _v == '-1':
     mqttSendMessage(oc['device_name'] + '/set', '{"'+oc['variable_name']+'":"TOGGLE"}')
    elif _v == '1':
     mqttSendMessage(oc['device_name'] + '/set', '{"'+oc['variable_name']+'":"ON"}')
    elif _v == '0':
     mqttSendMessage(oc['device_name'] + '/set', '{"'+oc['variable_name']+'":"OFF"}')
   errDevices.setPing(_k)
  SQL.delVal('zigbee_cmd', _k)
def zigbeeTryAdd2globalErr():
 global errDevices
 err = errDevices.getErr()
 if len(err) > 0:
  sys_conn_error.set('zigbee', err)
 else:		
  sys_conn_error.set('zigbee', '')
def check_state():
 global DATA_OBJ
 global errDevices
 for a in DATA_OBJ:
  o = DATA_OBJ[a]
  if o['typ'] == 'pk':
   mqttSendMessage(o['device_name'] + '/get', '{"'+o['variable_name']+'":""}')
  else:
   mqttSendMessage(o['device_name'] + '/avability', '')
  errDevices.setPing(a)
def mqttReadMessage(o, topic, msg):
 global DATA_OBJ, DATA_VAR, DATA_MEM
 global errDevices
 DATA_MEM[fn.date_full(True)] = fn.simple_chars(topic + ':' + msg)
 try:
  o = json.loads(str(msg))
 except:
  o = {}
 topic = topic.lower()	
 for a in DATA_OBJ:		
  oc = DATA_OBJ[a]
  if oc['device_name'] == topic:
   v_name = a;
   val_nr = var_get_float(o, oc['variable_name'], -987654)
   try:
    val = var_get(o, oc['variable_name'], '')
    val = val.lower()
   except:
    val = ''
    pass
   if len(val) > 0 :
    if len(oc['wyrazenie']['nie'])>0 and str(val).find(oc['wyrazenie']['nie']) != -1:
     DATA_VAR[v_name] = 0
    elif len(oc['wyrazenie']['tak'])>0 and str(val).find(oc['wyrazenie']['tak']) != -1:
     DATA_VAR[v_name] = 1
    elif len(oc['number_val']['reg'])>0 and len(val)>=1:
     if len(oc['number_val']['proc_min'])>0 and len(oc['number_val']['proc_max'])>0:
      vv = value.expression(val, oc['number_val']['reg'], -123456, [oc['number_val']['proc_min'], oc['number_val']['proc_max']])
     else:
      vv = value.expression(val, oc['number_val']['reg'], -123456)	
     watch_step = as_number(oc['number_val']['watch_step'], 0, True)
     if watch_step > 0 and vv != -123456:
      vv = step_number.check('zigbee_' +v_name, vv, watch_step, -123456)
     if vv != -123456:
      DATA_VAR[v_name] = vv
     DATA_VAR[v_name] = vv
    else:
     DATA_VAR[v_name] = val
   elif val_nr != -987654:
    DATA_VAR[v_name] = val_nr
   errDevices.setReply(v_name)
def mqttSendMessage(topic, message):
 global mqttObj
 if mqttObj:
  if type(message) is list:
   msg = ",".join(map(str, message))
   mqttObj.publish(topic, msg)
  else:
   mqttObj.publish(topic, message)
def mqttConnect():
 global FILE_CONFIG, mqttObj, mqttConnStr, mqttReadMessage
 conf = json_file_get_var(FILE_CONFIG, 'parameters.zigbee')
 _server = conf['mqtt_server']
 _port = conf['mqtt_port']
 _user = conf['mqtt_user']
 _passwd = conf['mqtt_passwd']
 _connstr = _server + _port + _user + _passwd		
 if mqttConnStr != _connstr:
  if mqttObj != False:
   mqttObj.close()
   mqttObj = False
  if len(_connstr) > 0:
   mqttObj = mqttBroker(_server, int(_port), 'ihomeZgbClient' + (uniqid() if PLATFORM == 'win' else ''))	
   mqttObj.setClientDevice('zigbee2mqtt', '')
   mqttObj.setFunctionMsg(mqttReadMessage)
   mqttObj.setSubscribe(['#'], 0)
   if len(_user) > 0 and len(_passwd) > 0:
    mqttObj.connect(_user, _passwd)
   else:
    mqttObj.connect()
   mqttConnStr = _connstr + ''
'''
if len(MQTT_PARAMS['user']) > 0 and len(MQTT_PARAMS['passwd']) > 0:
 mqttObj.connect(MQTT_PARAMS['user'], MQTT_PARAMS['passwd'])
else:
 mqttObj.connect()
'''
mqttConnect()
setInitialDataZigbee(True)
sys_workingModules.set('zigbee')
time.sleep(2)
check_state()
if PLATFORM == 'win':
 print('zigbee start')
x = 0
try:
 while 1:
  SQL.setValues('zigbee', DATA_VAR)
  check2do()
  DATA_MEM = SQL_REPLY.setSortLimit('zigbee', DATA_MEM, 20)
  if x % 200 == 0:
   mqttConnect()
  if x > 0 and x % 60 == 0:
   setInitialDataZigbee()
   sys_workingModules.set('zigbee')
  if x % 10 == 0: #co 10 sekund
   zigbeeTryAdd2globalErr()
  if x == 600: #co 5 min
   check_state()
  if x == 600: #10 min
   x = 1			
  else:
   x = x+1
  time.sleep(1)
except KeyboardInterrupt:
 print('Koniec') 
