from datetime import datetime
import time
import math
import re
from lib.functions import http_get, var_get, var_get_float
class fn:
 def simple_chars(str):
  return re.sub('[^a-zA-Z0-9 _=\@\#\$\%\^\&\*\(\)\[\]\;\:\<\>\?\+\-]{1,}', '', str)
 def date_full(add_msc = False):
  return datetime.now().strftime("%Y-%m-%d %H:%M:%S.%f")[:-3] if add_msc == True else datetime.now().strftime("%Y-%m-%d %H:%M:%S")
 def getweather(APIkey, pos_lat, pos_long):
  url = 'https://api.openweathermap.org/data/2.5/weather?lat='+pos_lat+'&lon='+pos_long+'&units=metric&appid=' + APIkey
  ok, obj = http_get(url, 5, 'json')
  ret = {'temperature':0, 'humidity' : 0, 'pressure' : 0}
  if ok == True:
   ret = {'temperature' : round(var_get_float(obj, 'main.temp', 0), 1), 'humidity' : var_get(obj, 'main.humidity', 0), 'pressure' : var_get(obj, 'main.pressure', 0)}		
  return ret
 def sunriseset(y, m, d, pos = {}):
  R = y
  M = m
  D = d
  Lat = 49.849302
  Long = 19.732994
  Lat = var_get_float(pos, 'lat', Lat)
  Long = var_get_float(pos, 'long', Long)
  Req = -0.833
  J = 367*R-int(7*(R+int((M+9)/12))/4)+int(275*M/9)+D-730531.5;
  Cent = J/36525;
  L = (4.8949504201433+628.331969753199*Cent) % 6.28318530718;
  G = (6.2400408+628.3019501*Cent) % 6.28318530718;
  O = 0.409093-0.0002269*Cent;
  F = 0.033423*math.sin(G)+0.00034907*math.sin(2*G);
  E = 0.0430398*math.sin(2*(L+F)) - 0.00092502*math.sin(4*(L+F)) - F;
  A = math.asin(math.sin(O)*math.sin(L+F));
  C = (math.sin(0.017453293*Req)-math.sin(0.017453293*Lat)*math.sin(A)) / (math.cos(0.017453293*Lat)*math.cos(A));
  Wsch = (math.pi - (E+0.017453293*Long+1*math.acos(C)))*57.29577951/15;
  Zach = (math.pi - (E+0.017453293*Long+(-1)*math.acos(C)))*57.29577951/15;
  Wsch = Wsch + 1
  Zach = Zach + 1
  w = fn._sunriseset_prepare(Wsch)
  z = fn._sunriseset_prepare(Zach)
  return [w, z]
 def _sunriseset_prepare(n):
  m, g = math.modf(n)
  g = int(g)
  m = round(m * 60)
  full_str = (('0' + str(g)) if g < 10 else str(g)) + ':' + ('0' + str(m) if m < 10 else str(m))
  return [g, m, full_str]
def lifepo4_proc(v, dz=16):
 if type(v) is str:
  v = float(v)
 v = v / dz
 def px(val, min, max, proc_min, proc_max):
  st = (val-min) / (max-min)
  proc = proc_min + st * (proc_max - proc_min)
  return int(proc)
 if v > 3.65:
  return 100
 elif v >= 3.4:
  return 100
 elif v >= 3.35:
  return px(v, 3.35, 3.4, 90, 100)
 elif v >= 3.32:
  return px(v, 3.32, 3.35, 80, 90)
 elif v >= 3.3:
  return px(v, 3.3, 3.32, 70, 80)
 elif v >= 3.27:
  return px(v, 3.27, 3.3, 60, 70)
 elif v >= 3.26:
  return px(v, 3.26, 3.27, 50, 60)
 elif v >= 3.25:
  return px(v, 3.25, 3.26, 40, 50)		
 elif v >= 3.22:
  return px(v, 3.22, 3.25, 30, 40)		
 elif v >= 3.20:
  return px(v, 3.20, 3.22, 20, 30)
 elif v >= 3.0:
  return px(v, 3.0, 3.2, 10, 20)
 elif v >= 2.5:
  return px(v, 2.5, 3.0, 0, 10)		
 else:
  return 0