import xml.etree.cElementTree as et
from lib.functions import *
from lib.value_class import value
class devices_do:
 timeout_afe = 5
 timeout_lk = 4
 @classmethod
 def read_all(self, obj, name = '', only_lk = False):
  zwrot = {}
  is_connect = True
  for a in obj:
   n = a['nazwa']
   if len(a["nazwa"]) > 0 and ((len(name) > 0 and name == n) or len(name) == 0) and is_eq_int(a, 'aktywny', 1):
    if (a['typ'] == 'afe_1ch' or a['typ'] == 'afe_1ch_v3') and only_lk == False:
     if a['typ'] == 'afe_1ch_v3':						
      is_ok, _z = self.afe_1ch_read(a, {'version' : 3})
     else:
      is_ok, _z = self.afe_1ch_read(a)
     zwrot[n] = _z
     if is_ok == False:
      is_connect = False
    elif a['typ'] == 'arduino-v1':
     is_ok, _z = self.arduino_read(a)					
     for b in _z:
      zwrot[n + '.' + b] = _z[b]
     if is_ok == False:
      is_connect = False				
    elif a['typ'] == 'lk2' or a['typ'] == 'lk3':
     _lk_fields = (a['param']).split(';')
     _url = self._deviceGetUrl(a)
     if a['typ'] == 'lk2':
      _full_url = _url + 'st0.xml'
     else:
      _full_url = _url + 'xml/ix.xml'
     is_ok, ret = self._http_get(_full_url, self.timeout_lk, '', a)
     if is_ok:
      vvv = self._getObjectFromXmlByParams(ret, _lk_fields, True if a['typ'] == 'lk2' else False)
      for b in vvv:
       zwrot[n + '.' + b] = vvv[b]
     else:
      is_connect = False
      for b in _lk_fields:
       if b.find('=') > 0:
        _b, _tmp = b.split('=')
        if _b.find('*') > 0:
         _b, _mn = _b.split('*')
       else:
        _b = b
       zwrot[n + '.' + _b] = ''
  return [is_connect, zwrot] if len(name) > 0 else zwrot
 @classmethod
 def send2device(self, obj, n, action):
  is_find = False
  is_connect = False
  val = 0
  for a in obj:
   if is_find == False and (a['typ'] == 'afe_1ch' or a['typ'] == 'afe_1ch_v3') and a['nazwa'] == n:
    is_find = True
    is_connect, val = self.afe_1ch_send(a, action)
  if is_find:
   return [True, is_connect, val]
  else:
   for a in obj:
    if is_find == False and (a['typ'] == 'lk2' or a['typ'] == 'lk3'):
     is_find, is_connect, val = self.lk_send_action(a, n, action)
    if is_find == False and (a['typ'] == 'arduino-v1'):
     is_find, is_connect, val = self.arduino_send_action(a, n, action)
  return [is_find, is_connect, val]
 @classmethod
 def lk_send_action(self, a, _n, action):		
  is_find = False		
  _lk_fields = (a['param']).split(';')
  for b in _lk_fields:
   if b.find('=') > 0:
    _a, _b = b.split('=')
   else:
    _a, _b = [b, b]
   if a['nazwa'] + '.' + _a == _n:
    is_find = True
    _action = int(action) if len(str(action))>0 else -1
    f_name = _b
    url = self._deviceGetUrl(a)
    if _action == -1:
     if a['typ'] == 'lk3' and f_name.find('pwm')==0:
      full_url = url + 'outs.cgi?pwm=' + f_name
     else:
      full_url = url + 'outs.cgi?out=' + f_name
    elif _action == 1 or _action == 0:
     if a['typ'] == 'lk2':
      full_url = url + 'outs.cgi?' + f_name + '=' + ('0' if str(_action) == '1' else '1')
     else:
      full_url = url + 'outs.cgi?' + f_name + '=' + str(_action)
    is_ok, ret = self._http_get(full_url, 2, False, a)
    _v = 0
    if is_ok:
     if a['typ'] == 'lk2':
      _xml_val = ret
     else:
      _xml_val = self._getValFromXml(ret, 'out', '')
     try:
      nr = int(_b[3:])
      _v = _xml_val[nr:nr+1]
      if a['typ'] == 'lk2':
       _v = 1 if (_v == 0 or _v == '0') else 0
     except Exception:
      pass
    return [True, is_ok, _v]
  return [False, False, False]
 @classmethod
 def arduino_send_action(self, a, _n, action):		
  is_find = False		
  _lk_fields = (a['param']).split(';')
  for b in _lk_fields:
   if b.find('=') > 0:
    _a, _b = b.split('=')
   else:
    _a, _b = [b, b]
   if a['nazwa'] + '.' + _a == _n:
    is_find = True
    _action = int(action) if len(str(action))>0 else -1
    f_name = _b
    url = self._deviceGetUrl(a)
    print(f_name)
    full_url = url + 'index.php?todo=cmd&name=' + f_name + '&action=' +str( _action)
    is_ok, ret = self._http_get(full_url, 2, False, a)
    print(full_url, is_ok, ret)
    _v = 0
    if is_ok:
     if a['typ'] == 'lk2':
      _xml_val = ret
     else:
      _xml_val = self._getValFromXml(ret, 'out', '')
     try:
      nr = int(_b[3:])
      _v = _xml_val[nr:nr+1]
      if a['typ'] == 'lk2':
       _v = 1 if (_v == 0 or _v == '0') else 0
     except Exception:
      pass
    return [True, is_ok, _v]
  return [False, False, False]
 @classmethod	
 def arduino_read(self, a):
  _url = self._deviceGetUrl(a, True) + 'json'		
  is_ok, ret = http_get(_url, self.timeout_afe, 'json')		
  vars = self._parse_from_obj(ret if type(ret) is dict else {}, var_get(a, 'param', ''))
  return [is_ok, vars]
 @staticmethod
 def _parse_from_obj(obj, paramsStr):
  zw = {}
  if len(paramsStr) > 0:
   po = paramsStr.split(';')
   for e in po:
    _mn = ''
    if e.find('=') > 0:
     	_a, _b = e.split('=')
     	if _b.find('*') > 0:
     		_b, _mn = _b.split('*')
    else:
     	_a, _b = [e, e]
    v = var_get(obj, _b, '@#@')
    if v != '@#@':
     zw[_a] = as_number(v) if len(_mn) == 0 else value.multiply(v, _mn, '')
    else:
     zw[_a] = ''
  return zw
 @classmethod
 def afe_1ch_read(self, a, opt={}):
  _url = self._deviceGetUrl(a, True)
  _device = var_get_len(a, 'afe.device', 'relay')
  _name = var_get_len(a, 'afe.name', 'switch')
  _url =  _url + '?device='+_device+'&name='+_name+'&command=get'
  is_ok, ret = http_get(_url, self.timeout_afe, 'json')
  _ver = var_get(opt, 'version', 0);
  _gv = 'data.state' if _ver == 3 else 'value'
  if is_ok:	
   _v = var_get(ret, _gv, '')
   return [True, 1 if (_v == 'on' or _v == ':open') else 0]
  else:
   return [False, 0]
 @classmethod
 def afe_1ch_send(self, a, action):
  url = self._deviceGetUrl(a, True)
  _device = var_get_len(a, 'afe.device', 'relay')
  _name = var_get_len(a, 'afe.name', 'switch')		
  url =  url + '?device='+_device+'&name='+_name+'&command=' + ('toggle' if (action == -1 or action == '-1') else ('on' if (action==1 or action == '1') else 'off'))
  is_ok, ret = http_get(url, self.timeout_afe, 'json')
  if is_ok:
   return [True, 1 if var_get(ret, 'value', '?') == 'on' else 0]
  else:
   return [False, False]
 @staticmethod
 def _http_get(url, timeout, ret_type='', obj = {}):
  _login = var_get(obj, 'access.login', '')
  _pass = var_get(obj, 'access.passwd', '')
  if len(_login)>0 and len(_pass) > 0:
   return http_get(url, timeout, ret_type, {'auth':[_login, _pass]})
  else:
   return http_get(url, timeout, ret_type)		
 @staticmethod
 def _deviceGetUrl(o, addAuth = False):
  if addAuth and len(o['access']['login']) > 0 and len(o['access']['passwd']) > 0:
   return 'http://' + o['access']['login'] + ':' + o['access']['passwd'] + '@' + o['ip'] + (':' + o['port'] if len(o['port']) > 0 else '') + '/'
  else:
   return 'http://' + o['ip'] + (':' + o['port'] if len(o['port']) > 0 else '') + '/'	
 @staticmethod
 def _getValFromXml(xmlStr, n, defV = False):
  try:
   tree = et.fromstring(xmlStr)
   el = tree.find(n)
   if el != None:
    return el.text
   else:
    return defV
  except Exception as e:
   return defV
 @staticmethod
 def _getObjectFromXmlByParams(xmlStr, listF, is_rev = False):
  try:
   tree = et.fromstring(xmlStr)
   _pwm = tree.find('pwm')
   _pwmS = str(bin(int(_pwm.text)).replace("0b", ""))
   _pwmS = ('0' * (4-len(_pwmS))) + _pwmS
   _pwmO = {'pwm0' : 1 if _pwmS[3:4]=='1' else 0, 'pwm1' : 1 if _pwmS[2:3]=='1' else 0, 'pwm2' : 1 if _pwmS[1:2]=='1' else 0, 'pwm3' : 1 if _pwmS[0:1]=='1' else 0}
   _inpd = tree.find('ind')
   if _inpd != None:
    _inpdS = str(bin(int(_inpd.text)).replace("0b", ""))
    _inpdS = ('0' * (4-len(_inpdS))) + _inpdS
    _inpdO = {'inpd1' : 1 if _inpdS[3:4]=='1' else 0, 'inpd2' : 1 if _inpdS[2:3]=='1' else 0, 'inpd3' : 1 if _inpdS[1:2]=='1' else 0, 'inpd4' : 1 if _inpdS[0:1]=='1' else 0}
   else:
    _inpdO = {}
   ret = {}
   for a in listF:
    _mn = '';
    if a.find('=') > 0:
     _a, _b = a.split('=')
     if _b.find('*') > 0:
      _b, _mn = _b.split('*')
    else:
     _a, _b = [a, a]
    el = tree.find(_b)
    if el != None:
     val = el.text
     if is_rev and (_b == 'out0' or _b == 'out1' or _b == 'out2' or _b == 'out3' or _b == 'out4' or _b == 'out5'):
      val = (1 if val == '0' else 0) if (val == '1' or val == '0') else val
     elif is_rev == False and (_b == 'out0' or _b == 'out1' or _b == 'out2' or _b == 'out3' or _b == 'out4' or _b == 'out5'):
      val = (0 if val == '0' else 1) if (val == '1' or val == '0') else val
     elif is_rev and (_b == 'di0' or _b == 'di1' or _b == 'di2' or _b == 'di3'):
      val = (1 if val == 'up' else 0) if (val == 'up' or val == 'down') else val
     elif _b == 'ds1' or _b == 'ds2' or _b == 'ds3' or _b == 'ds4' or _b == 'ds5' or _b == 'ds6':
      _tmp_val = as_number(val)
      val = -4321 if (_tmp_val < -500 or _tmp_val > 800) else _tmp_val
     if val == '-60':
      val = '';						
     else:
      val = val if len(_mn) == 0 else value.multiply(val, _mn, '')
     ret[_a] = val
    elif _b.find('pwm') != -1:
     ret[_a] = var_get(_pwmO, _b, 0)
    elif _b.find('inpd') != -1:
     ret[_a] = var_get(_inpdO, _b, -1)
    else:
     ret[_a] = ''
   return ret
  except Exception as e:
   return {}
