<?php

/*	..................................	

	SESSIONS
	autor: Marcin ukasiewicz, www.m-l.pl
	
	ver.: 1.0
*/

class session
{
	var $name;
	var $id;

	function __construct($name = false)
	{
		if($name)
			$this -> name = $name;
	}
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	
	public function start($session_id = false)
	{
		if($this -> name)
			session_name($this -> name);
		else
			$this -> name = session_name();

		if($session_id)
		{
			session_id($session_id);
			$this -> id = $session_id;
		}

		@session_start();

		if(!$session_id)
			$this -> id = session_id();
	}
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	
	public static function livetime($t = false)
	{
		if($t && is_int($t))
			return session_cache_expire($t);
		else
			return session_cache_expire();
	}
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	
	public static function setDir($dir)
	{
		if(is_dir($dir))
			session_save_path($dir);
		else
			endmsgF("Klasa - ses, niepoprawny katalog(".$dir.").");
	}
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	
	public static function set($n, $v="")
	{
		$_SESSION[$n] = $v;	

		return $v;
	}
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	
	public static function setOne($n, $v = '')
	{
		if(!array_key_exists($n, $_SESSION) || $_SESSION[$n] == '')
		{
			$_SESSION[$n] = $v;
			return $v;
		}
		else
			return $_SESSION[$n];
	}
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	
	public static function del($n)
	{
		unset($_SESSION[$n]);
	}
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	
	public static function get($n, $def_ret = false)
	{
		if(isset($_SESSION) && array_key_exists($n, $_SESSION))
			return $_SESSION[$n];
		else
			return $def_ret;
	}
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	
	public static function getId()
	{
		return session_id();
	}
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	
	public static function stop()
	{
		session_destroy();
	}
}

?>