<?php


class protocol
{
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function curl_get_simple($url, $timeout = false)
	{
		$x = self :: curl_get($url, false, $timeout);
		return $x[0];
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function curl_get($url, $type = false, $timeout = false)
	{
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_POST, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		
		curl_setopt($ch, CURLOPT_TIMEOUT, $timeout? $timeout : 10);
		
		$output = curl_exec($ch);
		$err = curl_error($ch);
		curl_close($ch);		

		if($output > '')
		{
			if($type == 'json')
				$output = json_decode($output, true);
			else if($type == 'xml')
			{
				$output = simplexml_load_string($output);
				$output = get_object_vars($output);
			}

			return array(true, $output);
		}
		else
			return array(false, $err);
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	
	public static function wake_on_lan($addr, $mac, $port = 9)
	{
		$addr_byte = explode('-', str_replace(':', '-', $mac));
		$hw_addr = '';
		//exit($addr.'#'.$mac.'#'.$port);
		for ($a=0; $a <6; $a++)
			$hw_addr .= chr(hexdec($addr_byte[$a]));
		
		$msg = chr(255).chr(255).chr(255).chr(255).chr(255).chr(255);
		
		for ($a = 1; $a <= 16; $a++)
			$msg .= $hw_addr;
		
		// send it to the broadcast address using UDP
		$s = socket_create(AF_INET, SOCK_DGRAM, SOL_UDP);
		
		if ($s == false)
		{
			//echo "Error creating socket!\n";
			//echo "Error code is '".socket_last_error($s)."' - " . socket_strerror(socket_last_error($s));
			return FALSE;
		}
		else
		{
			// setting a broadcast option to socket:
			$opt_ret = @socket_set_option($s, 1, 6, TRUE);
			
			if($opt_ret <0)
			{
				echo "setsockopt() failed, error: " . strerror($opt_ret) . "\n";
				return FALSE;
			}
			
			if(socket_sendto($s, $msg, strlen($msg), 0, $addr, $port))
			{
				socket_close($s);
				return TRUE;
			}
			else
			{
				return FALSE;
			}
		}
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function ping($host, $port, $timeout = 1)
	{
		return false;
		$fp = @fsockopen($host, $port, $errCode, $errStr, $timeout);

		if ($fp)
		{
			fclose($fp);
			return true;
		}
		@fclose($fp);
		
		//if(self :: ping_pi($host, 10))
			//return true;

		return false;
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	private static function ping_pi($host, $timeout = 1)
	{
		$result = false;
		
		/* ICMP ping packet with a pre-calculated checksum */
		$package = "\x08\x00\x7d\x4b\x00\x00\x00\x00PingHost";		
		//$socket  = socket_create(AF_INET, SOCK_RAW, 1);
		$socket = socket_create(AF_UNIX, SOCK_STREAM, 0);
		socket_set_option($socket, SOL_SOCKET, SO_RCVTIMEO, array('sec' => $timeout, 'usec' => 0));
		socket_connect($socket, $host, null);
		$ts = microtime(true);

		socket_send($socket, $package, strLen($package), 0);

		if (@socket_read($socket, 255))
		{
			$result = microtime(true) - $ts;
		}
		
		socket_close($socket);
		
		return $result;
	}
}

?>
