<?php



if(!defined('ROOT_DIR'))
{
	//define('ROOT_DIR', './');
	define('ROOT_DIR', dirname(__FILE__) . '/');
}

include_once(ROOT_DIR . '_top.php');

set_time_limit(240);

$RAM_DISK_PATH = arr :: getm($CONFIG, 'parameters.main.ram_disk_path', '');
$RAM_DISK_PATH = $RAM_DISK_PATH > '' ? $RAM_DISK_PATH  : ROOT_DIR . 'data/';

session_start();

function authenticate()
{
    if(!file_exists(ROOT_DIR . 'lock.txt'))
    	file_put_contents(ROOT_DIR . 'lock.txt', 1);
    else
    {
    	$ile = file_get_contents(ROOT_DIR . 'lock.txt');
    	if($ile == 4)
    		exit('lock panel');
    	else
	    	file_put_contents(ROOT_DIR . 'lock.txt', $ile + 1);
    }

	header('WWW-Authenticate: Basic realm="Raspbery iHome Controler - Access"');
	header('HTTP/1.0 401 Unauthorized');
	echo "Raspbery iHome Controler - podaj login i haslo aby zarzadzac urzadzeniem\n";

    exit;
}

function is_windows()
{
	$sv = 'SystemRoot';
	$n = 'windows';

	if(isset($_SERVER[$sv]) && strpos(strtolower($_SERVER[$sv]), $n) !== false)
		return true;

	return false;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

$IS_ARGV = false;

if(isset($argv) && is_array($argv) && count($argv) >= 1)
{
	$A = $argv[1];
	$B = isset($argv[2])? $argv[2] : false ;
	$C = isset($argv[3])? $argv[3] : false ;  
	$IS_ARGV = true;
}
else
{
	$A = http :: _get('a');
	$B = http :: _get('b');
	$C = http :: _get('c');
}

$_u = arr :: getm($CONFIG, 'parameters.access.user', '');
$_p = arr :: getm($CONFIG, 'parameters.access.passwd', '');

if($_u > '' && $_p > '' && !$IS_ARGV && $A != 'set_read_all')
{
	if (!isset($_SERVER['PHP_AUTH_USER']) || ($_SERVER['PHP_AUTH_USER'] != $_u || $_SERVER['PHP_AUTH_PW'] != $_p))
		authenticate();
}

if(file_exists(ROOT_DIR . 'lock.txt'))
	unlink(ROOT_DIR . 'lock.txt');

define('DARK_MODE_FILE', ROOT_DIR . 'data/dark_mode.f');
define('DARK_MODE_DISP', file_exists(DARK_MODE_FILE));

/*
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'change_disp_mode':

		if(DARK_MODE_DISP)
			unlink(DARK_MODE_FILE);
		else
			file_put_contents(DARK_MODE_FILE, '');

		header('Location: index.php?a=form_edit&b=parameters');

	break;
*/


if($A == 'color_scheme_change')
{
	$_ch = http :: _get('color_scheme');

	if($_ch == 'dark' || $_ch == 'light')
		session :: set('color_cheme', $_ch);
	else
		session :: del('color_cheme');

	exit('ok: ' . $_ch);
}

switch($A)
{
	case 'info':

		if($B == 'version')
			exit(VERSION);
		else if($B == 'update_date')
			exit(UPDATE_DATE);
		else
			exit('IHOME RASPBERRY CONTROLER');

	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -	

	case 'remote_info_get':

		$obj = device :: get_remote_info();

		exit(json_encode($obj));

	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -	

	case 'power':

		$b = http :: _get('b');

		if($b == 'restart' || $b == 'reboot')
		{
			//pt :: command('power', 'reboot');
			pt :: command('read_write', 'power', 'reboot');
		}
		else if($b == 'shutdown')
		{
			//pt :: command('power', 'shutdown');
			pt :: command('read_write', 'power', 'shutdown');
		}

		exit('power command - '.$b.': ok');

	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'ftp':

		if(device :: is_develop())
		{
			define('FTP_START_DIR', '../');
			include_once('../ftp.php');
		}

		header('Location: index.php?a=index.php');
	
	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'backup':
	case 'backup_action':

		$action = http :: _get('b');

		if($action == 'backup')
		{
			list($is, $str) = backup :: get();
			
			if($is)
			{
				header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
				header('Last-Modified: '.gmdate('D, d M Y H:i:s') . ' GMT');
				header('Cache-Control: no-store, no-cache, must-revalidate');
				header('Cache-Control: public'); 
				header('Pragma: no-cache'); 
				header('Content-type: application/json');
				header('Content-Disposition: attachment; filename=rbic_backup_'.date('Y-m-d_Hi').'.json');
				header('Content-Length: '.mb_strlen($str));
				header('Content-Transfer-Encoding: binary');
				header('Content-Encoding: AnyTrash');
				exit($str);
			}
			else
				exit(html :: msg('blad', $str));
		}
		else if($action == 'restore_form')
		{
			echo html :: header('Backup danych i przywracanie');

			$s = '<form action="index.php?a=backup&b=restore_file" method="post" enctype="multipart/form-data">
				<label for ="">Plik konfiguracyjny:</label><br>				
				<input type="file" name="plik"><br><br>
				<input type="submit" value="Przywróć">
			</form>';

			echo $s;

			echo html :: footer();						
		}
		else if($action == 'restore_file')
		{
			$n = 'plik';
			
			if(isset($_FILES[$n]) && is_uploaded_file($_FILES[$n]['tmp_name']))
			{
				$s = file_get_contents($_FILES[$n]['tmp_name']);
				list($ok, $ret) = backup :: set($s);
				if($ok)
				{
					header('Location: index.php');
				}
				else
					exit(html :: msg($ret));
			}
			else
				exit(html :: msg('Nie przesłano pliku'));
			
		}
		else if($action == 'local_files_list')
		{
			$a = glob(ROOT_DIR . 'data/backup_*.json');

			echo html :: header('Lista lokalnych plików z danymi');

			$s = '<div>';

			foreach($a as $v)
			{
				$f = basename($v);
				$lnk1 = '<a href="index.php?a=backup&b=local_restore_do&file='.$f.'">przywróć</a>';
				$lnk2 = '<a href="index.php?a=backup&b=local_delete&file='.$f.'"">usuń</a>';

				$s .= '<div>'.$f.'&nbsp;&nbsp;&nbsp;&nbsp;'.$lnk1.' | '.$lnk2.'</div>';
			}

			echo $s . '</div>';

			echo html :: footer();
		}
		else if($action == 'backup_local')
		{
			list($ok, $s) = backup :: get();

			if($ok)
			{
				$n = 'data/backup_'.date('Y-m-d_Hi').'.json';
				
				file_put_contents(ROOT_DIR . $n, $s);
				
				if($A == 'backup_action')
					exit('backup ok: ' . $n);
				else
					header('Location: index.php?a=backup&b=local_files_list');
			}
			else
				exit(html :: msg($s));
		}		
		else if($action == 'local_restore_do')
		{
			$f = ROOT_DIR . 'data/' . http :: _get('file', '_e123gg.json');

			list($ok, $s) = backup :: set(file_get_contents($f));
			if($ok)
			{
				header('Location: index.php');
			}
			else
				exit(html :: msg($s));
		}
		else if($action == 'local_delete')
		{
			$f = ROOT_DIR . 'data/' . http :: _get('file', '_e123gg.json');
			
			if(file_exists($f))
				unlink($f);

			header('Location: index.php?a=backup&b=local_files_list');
		}
		else if($action == 'get_str')
		{			
			$str = backup :: get();
		
			exit($str[1]);
		}
		else
		{
			echo html :: header('Backup danych i przywracanie');

			$s = '';

			$s .= '<h2 class="mgb5">Kopia lokalna</h2>';
			$s .= '<a href="?a=backup&b=backup_local">Tworzenie lokalnej kopii zapasowej</a>';
			$s .= '<br>';
			$s .= '<a href="?a=backup&b=local_files_list">Lista lokalnych kopii zapasowych</a>';

			$s .= '<h2 class="mgt20 mgb5">Kopia zewnętrzna</h2>';
			$s .= '<a href="?a=backup&b=backup">Pobieranie pliku konfiguracyjnego</a>';			
			$s .= '<br>';
			$s .= '<a href="?a=backup&b=restore_form">Przywracanie danych</a>';

			echo $s;

			echo html :: footer();
		}

	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'logs_list':
	case 'logs_list_json':

		$links = array(
			'logi' => '?a=logs_list',
			'logi użytkownika' => '?a=logs_list&b=user'
		);

		$html = html :: header('logi', array('menu' => $links));

		$fc = $RAM_DISK_PATH;// arr :: getm($CONFIG, 'parameters.ram_disk_path');
		$file = $B == 'user'? $fc . 'log_user.json' : $fc . 'log.json';

		if(file_exists($file))
		{
			$str = file_get_contents($file);
			$obj = json_decode($str, true);
			$obj1 = array();
			
			foreach($obj as $v)
			{
				$dn = substr($v['date'], 0, 10);
				
				if(!array_key_exists($dn, $obj1))
					$obj1[$dn] = array();

				$obj1[$dn][] = $v;
			}

			$s = '<table class="list full">';
			foreach($obj1 as $k1 => $v1)
			{
				$s .= '<tr><td>'.$k1.'</td><td colspan="5"></td></tr>';
				foreach($v1 as $k2 => $v2)
				{
					$css = $v2['color']>''?'color:'.$v2['color'].';':'';
					@$s .= '<tr><td></td><td style="'.$css.'">'.$v2['mod'].'</td><td style="'.$css.'">'.$v2['name'].'</td>';
					$s .= '<td>'.substr($v2['date'], 11).'</td><td>ilość: '.$v2['count'].'</td>';
					$s .= '<td><a href="#" onclick="box.show(\'div\', \'#box_det_'.$k1.'_'.$k2.'\'); return false;">pokaż dane</a></td></tr>';
				}
			}
			$s .= '</table>';

			$html .= $s;
		
			foreach($obj1 as $k1 => $v1)
			{
				foreach($v1 as $k2 => $v2)
				$html .= '<div class="box" id="box_det_'.$k1.'_'.$k2.'" style="display:none;"><div class="box_header">Dane / '.$v2['name'].'</div><div class="box_content"><pre>'.print_r($v2['data'], true).'</pre></div></div>';	
			}
		}
		else{
			$str = '';
		}
		
		$html .= html :: footer();

		if($A == 'logs_list')
			echo $html;
		else
			exit($str);

	break;


	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	
	case 'help':

		echo html :: header('Pomoc');

		$a = array(
			'install_rpi' => html :: tpl('src/help_install_rpi.html'),
			'install_rpi_control' => html :: tpl('src/help_install_control.html'),
			'out_lib' => html :: tpl('src/help_install_out_lib.html'),
			'config' => html :: tpl('src/help_config.html'),
			'biblioteka' => html :: tpl('src/biblioteka.html')
		);

		echo html :: tpl('src/help.html', $a);

		echo html :: footer();

	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'print_spec':

		function dfsdfs12122dfsdf($obj)
		{
			$s = '';

			foreach($obj as $v)
			{
				$s .= "\t" . '<div style="margin-top:5px;">';
				$s .= '<p>'.arr :: get($v, 'nazwa', '').'';
				
				if(isset($v['opis']) && $v['opis'] > '')
					$s .= ' <span class="f-min"> / '.$v['opis'].'</span>';
				if(isset($v['opis_1']) && $v['opis_1'] > '')
					$s .= ' <span class="f-min"> / '.$v['opis_1'].'</span>';


				$s .= '</p>';

				$s .= '</div>' . "\n";
			}

			return $s;
		}

		echo html :: header('Specyfikacja');

		$hName = array(
			//'access' => 'Dostęp',
			//'parameters' => 'Parametry',
			'events' => 'Zdarzenia',
			'variables' => 'Zmienne',
			'gpio' => 'Piny GPIO',
			'time' => 'Zdarzenia czasowe',
			'ports' => 'Porty',
			'rs485' => 'RS 485',
			'i2c' => 'I2C',
			'rflink' => 'RFlink',
			'devices' => 'Zewnętrzne urządzenia'
		);

		$s = '';
		echo '<pre style="font-family:verdana;font-size:10px;">'.print_r($CONFIG, true).'</pre>';die;
		foreach($CONFIG as $k => $v)
		{
			$s .= '<div><h3>'.arr :: get($hName, $k, '').'</h3></div>' . "\n";
			$s .= '<div style="padding:5px 0 20px 20px;">';
			
			
			if(is_array($v))
			{
				$ak = array_keys($v);
				
				if(is_array($v) && isset($ak[0]) && gettype($v[$ak[0]]) == 'string' && $k == 'access')
					$s .= "\t" . join(', ', $v) . "\n";
				else if($k == 'parameters')
					{}//$s .= "\t" . html :: tbl($v) . "\n";
				else
					$s .= dfsdfs12122dfsdf($v) . "\n";
			}

			$s .= '</div>' . "\n";
		}
		
		$cp = '<a href="#" onclick="page.copyText($(\'#spec_html_list_text\').val()); return false;" class="link">kopiuj tekst</a><br><textarea rows="1" cols="1" style="opacity:0;" id="spec_html_list_text">'.strip_tags($s).'</textarea>';
		echo '<div class="tbl full"><div class="td t">'.$s.'</div><div class="td t r">'.$cp.'</div></div>';

		echo html :: footer();	

	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'update':

		$b = http :: _get('b');

		//$menu = array('')

		if($b == 'log')
		{
			echo html :: header('Log ostatniej aktualizacji');

			if(file_exists(ROOT_DIR . 'data/log_update.json'))
			{
				$obj = json_decode(file_get_contents(ROOT_DIR . 'data/log_update.json'), true);				
				
     			echo html :: tbl_full($obj, array('name' => 'plik', 'is_dir' => 'czy katalog', 'date' => 'data', 'time_diff' => 'różnica', 'ok' => 'czy ok'));
			}
			else if(file_exists(ROOT_DIR . 'data/log_update.html'))
				echo file_get_contents(ROOT_DIR . 'data/log_update.html');
			else
				echo '--- brak pliku ---';

			echo html :: footer();
		}
		// else if($b == 'start')
		// {
		// 	list($a, $b) = curl :: get('http://localhost/ihome/update.php', false, 20);
			
		// 	exit($a? 'ok' : 'err: ' . $b);
		// }
		else
		{
			echo html :: header('Aktualizacja systemu');

			echo '
				<div class="center">
				Aktualna wersja systemu: <span class="bold">'.VERSION.'</span><br><br>
				Ostatnia aktualizacja: <span class="bold">'.(defined('UPDATE_DATE')? UPDATE_DATE : '--brak-danych--').'</span>
				</div><br>
				<a href="update.php?back2='.urlencode('index.php?a=update&b=log').'" onclick="wait_alert(\'Trwa proces aktualizacji systemu\');" class="link">aktualizuj system</a><br><br>
				<a href="index.php?a=update&b=log" class="link">log ostatniej aktualizacji</a>
			';

			if(device :: is_develop())
			{
				echo '<br><br><a href="update.php?ip_update=192.168.1.71&back2='.urlencode('index.php?a=update&b=log').'" class="link">aktualizuj lokalnie</a>';
				echo '<br>zmienić SERVER_ADMIN w pliku:  /etc/apache2/sites-available/000-default.conf';
			}

			echo html :: footer();
		}

	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'ptcmds':

		if($B == 'kill_process_nr')
		{
			echo pt :: command('cmds', 'kill_process_nr', http :: _get('nr', ''));
		}

	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'adv':

		if($B == 'kill_process')
		{}
		else if($B == 'ch_version' && device :: is_develop())
		{
			$f = '../_conf.php';
			if(file_exists($f) && $C > '')
			{
				$s = file_get_contents($f);
				$s1 = preg_replace("/'VERSION', '([0-9\.]{1,})'/", "'VERSION', '$C'", $s);
				file_put_contents($f, $s1);
				header('Location: '.$_SERVER['HTTP_REFERER']);
			}
		}
		else if($B == 'dops')
		{
			//echo pt :: command('cmds', 'dops', http :: _get('ps', ''));
		}
		else if($B == 'list_ems')
		{
			$ret = array();
			foreach($CONFIG as $e => $v)
			{
				if(is_array($v))
				{
					foreach($v as $kx => $v1)
					{
						if(isset($v1['nazwa']))
							$ret[$v1['nazwa']] = array('n' => $e, 'i' => $kx);
					}
				}
			}
			exit(json_encode($ret));
			//echo '<pre style="font-family:verdana;font-size:10px;">'.print_r($ret, true).'</pre>';die;
		}
		else
		{
			die;
			echo html :: header('ADV');
			$s = '
				<span onclick="setps();">ps</span>
				<script>
				function setps()
				{
					var tx = prompt("ps");
					if(tx !== null && tx.length > 0)
						location.href = "index.php?a=adv&b=dops&ps="+tx
				}
				</script>
			';
			echo $s;
			echo html :: footer();		
		}		

	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'ric_check':

		$b = http :: _get('b');

		echo html :: header('Sprawdzenie systemu');

		$ret = pt :: command('cmds');

		$ret = json_decode($ret, true);
		
		echo '<table>';
		foreach($ret as $k => $v)
			echo '<tr><td class="right">'.$k.'</td><td>:&nbsp;&nbsp;&nbsp;&nbsp;</td><td class="'.($v=='ok'?'ok':'').'">'.$v.'</td></tr>';
		echo '</table>';

		// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

		echo '<br><br>';

		$_usage = pt :: command('cmds', 'usage');
		$_usage = json_decode($_usage, true);
		$_usage = html :: tbl($_usage);	

		$_errors = pt :: command('cmds', 'errors');
		$_errors = json_decode($_errors, true);
		//$_errors = mktblobj($_errors);
		$_errors = html :: tbl($_errors);

		echo <<<HTML
			<div class="elem three">
				<div class="em">
					<h3>Użycie</h3>
					{$_usage}
				</div>
				<div class="em">
					<h3>Błędy</h3>
					{$_errors}
				</div>				
			</div>
HTML;

		// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

		echo '<br><br>';
		echo '<h3>Uruchomione procesy</h3>';
		echo '<br>';

		//exec('sudo ps -aef | grep python', $_r);
		//$my_scripts = device :: get_scripts();
		$my_scripts = modules :: get_scripts();
		//$_r = device :: cmd('sudo ps -aef | grep python');
		$_r = device :: cmd('sudo ps aux | grep python');
		//$_r = array('617     1 /pt/mk.py','root python3 pt/mk2.py');
		$ret_scripts = array();		

		if(is_array($_r) && count($_r) > 0)
		{
			foreach($_r as $v)
			{
				$_t = explode('/', $v);
				$_e = substr($_t[count($_t)-1], 0, -3);

				if(!in_array($_e, $ret_scripts))
					$ret_scripts[] = $_e;
			}			
		}

		echo '<div class="elem five">';
		foreach($my_scripts as $k => $v)
		{
			echo '<div class="em"><div class="bx">';
			echo '<h4>'.$k.'</h4>';
			echo '<div class="mgt5 mgb10 f-min">'.$v['name'].'</div>';
			echo '<div class="right"><span class="'.(in_array($k, $ret_scripts)? 'ok':'err').'">'.(in_array($k, $ret_scripts)? 'ok':'skrypt zatrzymany').'</span></div>';
			echo '</div></div>';
		}
		echo '</div>';

		// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

		echo '<br><br>';
		echo '<h3>Użycie procesów</h3>';
		echo '<br>';

		echo parse_str :: get_tbl_usage($_r);

		echo html :: footer();

	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'devices_detect':
		
		$q = new http('q', false, 'b');
		//$q -> ch('b', 'detect_devices');

		$menu = array(
			'Detekcja urządzeń' => '?a='.$A.'&b=detect_devices',
			'RFLink - odczyt danych' => '?a='.$A.'&b=rf_link_read',
			'I2C - odczyt danych' => '?a='.$A.'&b=i2c_read',
			'RS485 - odczyt danych' => '?a='.$A.'&b=rs485_read',
			'Zigbee - odczyt danych' => '?a='.$A.'&b=zigbee_read',
		);

		if($q -> b == 'detect_devices')
		{
			echo html :: header('Lista urządzeń i dostępnych adresów', array('menu' => $menu));

			function get_out_ddt_old($obj)
			{
				$s = '';
				$t1 = '<div class="em"><div style="padding:2px;" class="bg-grey" data-css-all-h="devices">';
				$t2 = '</div></div>';
				foreach($obj as $k => $v){
					$s .= '<h3>'.$k.'</h3>'.(is_array($v) && count($v)>0? '<div class="elem six">'.$t1.''.join($t2.$t1, $v).''.$t2.'</div>' : '--brak urządzeń--');
					$s .= '<p>&nbsp;</p>';
				}
				
				return $s;
			}
			function get_out_ddt($obj)
			{
				$s = '';
				foreach($obj as $k => $v){
					$s .= '<h3>'.$k.'</h3>' . html :: tbl($v, array('only_val' => true));
					$s .= '<p>&nbsp;</p>';
				}
				
				return $s;
			}

			//sudo ps aux | grep python
			// sudo kill 616


			$_ds = device :: cmd('sudo ls /sys/bus/w1/devices/');
			$_i2c = device :: cmd('sudo i2cdetect -y 1');			
			//$_usb = is_windows()? device :: cmd('chgport') : device :: cmd('sudo ls /dev/tty*');
			$_usb = is_windows()? device :: cmd('chgport') : device :: cmd('sudo ls /dev/tty* |grep -i -v -E "tty[0-9]{1,}"');	
			$_usb_list1 = device :: cmd('ls /dev/serial/by-id/');
			$_usb_list2 = device :: cmd('lsusb');
					
			echo get_out_ddt([
				'Ds18B20' => $_ds, 'I2C' => $_i2c, 'USB' => $_usb, 'USB lista' => $_usb_list1, 'USB by ID' => $_usb_list2,
				'USB - przypisanie do portów' => device :: cmd('/var/www/html/ihome/sh/usb.sh')
			]);

			echo html :: footer();			
		}
		else if($q -> b == 'rf_link_read')
		{
			if($C == 'data')
			{
				$ret = pt :: command('cmds', 'rflink_data');
				exit($ret);
			}
			else
			{
				echo html :: header('RFLink - odczyt danych', array('menu' => $menu));	
				echo '<div style="width:100%; height:500px;" id="rflinkres"></div>';
				echo '<script>dataLiveJson.start("index.php?a='.$A.'&b='.$B.'&c=data", "#rflinkres");</script>'	;
				echo html :: footer();	
			}
		}
		else if($q -> b == 'i2c_read')
		{
			if($C == 'data')
			{
				$ret = pt :: command('cmds', 'i2c_data');
				exit($ret);
			}
			else
			{
				echo html :: header('I2C - odczyt danych', array('menu' => $menu));
				echo '<div style="width:100%; height:500px;" id="i2cres"></div>';
				echo '<script>dataLiveJson.start("index.php?a='.$A.'&b='.$B.'&c=data", "#i2cres");</script>'	;
				echo html :: footer();	
			}

		}		
		else if($q -> b == 'rs485_read')
		{
			if($C == 'data')
			{
				$ret = pt :: command('cmds', 'rs485_data');
				exit($ret);
			}
			else
			{
				echo html :: header('RS485 - odczyt danych', array('menu' => $menu));
				echo '<div style="width:100%; height:500px;" id="rs485res"></div>';
				echo '<script>dataLiveJson.start("index.php?a='.$A.'&b='.$B.'&c=data", "#rs485res");</script>'	;
				echo html :: footer();	
			}
		}
		else if($q -> b == 'zigbee_read')
		{
			if($C == 'data')
			{
				$ret = pt :: command('cmds', 'zigbee_data');
				exit($ret);
			}
			else
			{
				echo html :: header('Zigbee - odczyt danych', array('menu' => $menu));
				echo '<div style="width:100%; height:500px;" id="zigbeeres"></div>';
				echo '<script>dataLiveJson.start("index.php?a='.$A.'&b='.$B.'&c=data", "#zigbeeres");</script>'	;
				echo html :: footer();	
			}
		}
		else
		{
			echo html :: header('Detekcja urządzeń');

			echo '<div class="elem four">';
			foreach($menu as $k => $v)
				echo '<div class="em"><div class="bx"><a href="'.$v.'">'.$k.'</a></div></div>';
			echo '</div>';

			echo html :: footer();		
		}

	break;	

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'status_json':

		$ret1 = pt :: command('cmds');
		$ret2 = pt :: command('cmds', 'usage');
		$ret3 = pt :: command('cmds', 'modules');

		$ret1 = json_decode($ret1, true);
		$ret2 = json_decode($ret2, true);
		$ret3 = json_decode($ret3, true);
		
		$ret = array(
			'System' => $ret1,
			'Urzadzenie' => $ret2,
			'Moduly' => $ret3
		);

		//echo '<pre style="font-family:verdana;font-size:10px;">'.print_r($ret, true).'</pre>';die;
		exit(json_encode($ret));			

	break;


	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'set_read_all':

		$ret = pt :: command('read_write', '--read-all--', 'connect', http :: _get('name', ''));	
		
		exit('ok');

	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'read':
	case 'read_important':

		$ret = pt :: command('read_write', '--read-all--');
		
		if($A == 'read_important')
		{
			$d = json_decode($ret, true);
			$ret = array('err_connections_list' => array(), 'note_list' => array());
			foreach($d as $k => $v)
			{
				if($k == '_err_connections_list')
				{
					$x = explode('|', $v);
					foreach($x as $v1)
					{
						list($_a, $_b) = explode(':', $v1);
						$ret['err_connections_list'][$_a] = str_replace(',', ', ', $_b);
					}
				}
				else if($k == '_note_list')
					$ret['note_list'] = explode('|', $v);
			}
			//echo '<pre style="font-family:verdana;font-size:10px;">'.print_r($ret, true).'</pre>';die;
			exit(json_encode($ret));
		}
		else
			exit($ret);

	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'write':
	case 'write_elem':

		$name = http :: _get('name');
		//$ident = http :: _get('ident', 'switch');
		$action = http :: _get('action', '');
		$param = http :: _get('param', '');
		//$group = strpos($device, ':')>0? substr($device, 6) : '---';

		// exit("name:$name action:$action param:$param");

		if($action == '' && $param == '')
			$action = -1;
		
		if($A == 'write_elem')
			$ret = pt :: command('read_write', $name, $action, $param);
		else
			$ret = pt :: command('read_write', $name, $action, $param, 'log=1');

		header('Content-Type: application/json; charset=utf-8');
		exit($ret);

	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'configuration_get':
	case 'configuration_get_mqtt':

		$templates = configuration :: getTemplates($CONFIG);

		// - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

		$ret = array('response' => true);

		$ret['configuration'] = $CONFIG;
		$ret['configuration']['gpio'] = array('name' => 'GPIO', 'description' => 'w opracowaniu!!!', 'template' => arr :: get($templates, 'gpio', []), 'elements' => arr :: get($CONFIG, 'gpio', []));		
		$ret['configuration']['variables'] = array('name' => 'Zmienne', 'description' => 'w opracowaniu!!!', 'template' => arr :: get($templates, 'variables', []), 'elements' => arr :: get($CONFIG, 'variables', []));
		$ret['configuration']['events'] = array('name' => 'Zdarzenia', 'description' => 'w opracowaniu!!!', 'template' => arr :: get($templates, 'events', []), 'elements' => arr :: get($CONFIG, 'events', []));
		$ret['configuration']['time'] = array('name' => 'Czasowe', 'description' => 'w opracowaniu!!!', 'template' => arr :: get($templates, 'time', []), 'elements' => arr :: get($CONFIG, 'time', []));
		$ret['configuration']['tasks'] = array('name' => 'Zadania', 'description' => 'w opracowaniu!!!', 'template' => arr :: get($templates, 'tasks', []), 'elements' => arr :: get($CONFIG, 'tasks', []));
		$ret['configuration']['ports'] = array('name' => 'Porty', 'description' => 'w opracowaniu!!!', 'template' => arr :: get($templates, 'ports', []), 'elements' => arr :: get($CONFIG, 'ports', []));
		$ret['configuration']['rs485'] = array('name' => 'Rs485', 'description' => 'w opracowaniu!!!', 'template' => arr :: get($templates, 'rs485', []), 'elements' => arr :: get($CONFIG, 'rs485', []));
		$ret['configuration']['i2c'] = array('name' => 'I2C', 'description' => 'w opracowaniu!!!', 'template' => arr :: get($templates, 'i2c', []), 'elements' => arr :: get($CONFIG, 'i2c', []));
		$ret['configuration']['rflink'] = array('name' => 'RFLink', 'description' => 'w opracowaniu!!!', 'template' => arr :: get($templates, 'rflink', []), 'elements' => arr :: get($CONFIG, 'rflink', []));
		$ret['configuration']['devices'] = array('name' => 'Urządzenia zawnętrzne', 'description' => 'w opracowaniu!!!', 'template' => arr :: get($templates, 'devices', []), 'elements' => arr :: get($CONFIG, 'devices', []));		
		$ret['configuration']['parameters'] = array('name' => 'Parametry', 'description' => 'w opracowaniu!!!', 'template' => arr :: get($templates, 'parameters', []), 'elements' => arr :: get($CONFIG, 'parameters', []));
		


		$a = array(
			'install_rpi' => html :: tpl(ROOT_DIR . 'src/help_install_rpi.html'),
			'install_rpi_control' => html :: tpl(ROOT_DIR . 'src/help_install_control.html'),
			'config' => html :: tpl(ROOT_DIR . 'src/help_config.html')
		);

		$ret['help'] = html :: tpl(ROOT_DIR . 'src/help.html', $a);
		
		//header('Content-Type: application/json; charset=utf-8');
		$json = json_encode($ret);

		exit($json);

	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'configuration_save':
	case 'configuration_save_mqtt':

		if($A == 'configuration_save_mqtt')
		{
			$ff = ROOT_DIR . 'data/tmp_mqtt_conf.json';
			$str = (file_exists($ff))? file_get_contents($ff) : '' ;
		}
		else
			$str = http :: _post('configuration', '');

		$cfg = json_decode($str, true);

		if(gettype($cfg) == 'array')
		{
			$cf = new configuration(CONFIGURATION_FILE);
			
			if(!$cf -> save($cfg))
				exit("error save");

			if($A == 'configuration_save_mqtt' && file_exists($ff))
				unlink($ff);

			exit('ok');
		}
		else
			exit('error');

	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'save_data':

		$cf = new configuration(CONFIGURATION_FILE);

		if(configuration :: isValidElement($B))
		{
			$cf -> save_element($B, $_POST);
			$idn = '&b=' . $B;
		}
		else
		{
			$cf -> save($_POST);
			$idn = http :: _post('_idn', '');
		}		
		
		header('Location: index.php?a=form_edit' . $idn);

	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'data_actions':

		$action = http :: _get('action', '');
		$type = http :: _get('type', '');
		
		if($action == 'up' || $action == 'down')
		{			
			$nr = http :: _get('nr', 0);

			$cf = new configuration(CONFIGURATION_FILE);
			$cf -> ch_pos($type, $nr, $action);
		}
		else if($action == 'elements_set_active')
		{
			$name = http :: _get('name', '');

			$cf = new configuration(CONFIGURATION_FILE);
			$cf -> ch_active($type, $name);
			exit($type.'#'.$name)	;
		}

		header('Location: index.php?a=form_edit' . $idn.'&b=' . $type);

	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'form_edit':

		//$m = ($B == 'devices')? array('Zarządzanie kamerami' => 'index.php?a=cameras') : false ;
		$m = array();

		echo html :: header('Konfiguracja systemu', array('menu' => $m));

		//$_desc_open_therm = configuration :: getDescMods('open_therm');
		
		//$obj = configuration :: getElementsDesc();
		$obj = modules :: get_config_elem();
		

		//$obj['heating'] = array('name' => 'Piec Open-Therm', 'desc' => '', 'link' => '?a=boiler_ot_configuration', 'ico' => 'fa-fire', 'desc' => $_desc_open_therm);
		
		echo '<div class="elem '.($B?'six':'four').'">';
		
		foreach($obj as $k => $v)
		{
			$ic = html :: mk_ic($v['ico']);

			echo '<div class="em bx '.($k==$B?'zazn':'').'">';

			echo '<div data-css-all-h="form-e-d1">
				<div class="tbl">
					<div class="td m">'.$ic.'</div>
					<div class="td m f-plus">'.('<a href="'.(isset($v['link'])? $v['link'] : '?a=form_edit&b='.$k).'" class="">'.$v['name'].'</a>').'</div>
				</div>
				</div>
			';		
			
			if(!$B)
				echo '<div class="mgt-10 f-min" data-css-all-h="form-e-d2">'.$v['desc'].'</div>';

			echo '</div>';
		}
		
		echo '</div><br><hr><br>';


		if(configuration :: isValidElement($B))
		{
			if($B == 'parameters')
				echo '<div class="mgb-20"><a href="index.php?a=change_disp_mode" class="btn">zmień tryb ciemny/jasny</a></div>';

			//$d = configuration :: get_mod_desc($B);
			$d = modules :: get_mod_help($B);
			
			if($d)
				echo '<div class="bx mgb-20">'.$d.'</div>';

			if($B == 'parameters')
				echo html_form :: mk_form_parameters($CONFIG);
			else
				echo html_form :: mk_form_element($CONFIG, $B);
		}
		else if($B == 'open_therm' || $B == 'boiler_ot')
		{
			$cf = new configuration(CONFIGURATION_FILE);
			$conf = $cf -> get('boiler_ot');

			$ce = configuration :: getSystemElements($cf -> get());			
			$_variables = arr :: get($ce, 'variables', array());
			$_fields = arr :: get($ce, 'all_fields', array());

			include_once('inc/boiler_ot_configuration.php');
			//exit('<script>location.href="index.php?a=boiler_ot_configuration";</script>');
		}


		echo html :: footer();

	break;


	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	/*
	case 'form_edit_old':

		echo html :: header('Konfiguracja systemu');

		echo '<a href="?a=heating_configuration" class="link">Konfiguracja kontroli ogrzewania</a>';
		echo '<br><br>';

		if(configuration :: isValidElement($B))
			echo html :: mk_form_element($CONFIG, $B);
		else
			echo html :: mk_form($CONFIG);

		echo html :: footer();

	break;
	*/
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	/*
	case 'boiler_ot_configuration':

		$links = array('Powrót do konfiguracji ogólnej' => '?a=form_edit');

		echo html :: header('Konfiguracja ogrzewania', array('menu' => $links));

		$cf = new configuration(CONFIGURATION_FILE);
		$conf = $cf -> get('boiler_ot');

		$ce = configuration :: getSystemElements($cf -> get());

		//echo '<pre style="font-family:verdana;font-size:0px;">'.print_r($ce, true).'</pre>';die;
		$_variables = arr :: get($ce, 'variables', array());
		$_fields = arr :: get($ce, 'all_fields', array());
		
		include_once('inc/boiler_ot_configuration.php');

		echo html :: footer();		

	break;
	*/
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'boiler_ot_configuration_save':

		$cf = new configuration(CONFIGURATION_FILE);
		$cf -> save_simple_element('boiler_ot', $_POST);

		//header('Location: index.php?a=boiler_ot_configuration');
		header('Location: index.php?a=form_edit&b=boiler_ot');

	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'module_action':
	
		switch($B)
		{
			case 'boiler_ot_cfg_get':
				$cf = new configuration(CONFIGURATION_FILE);
				$conf_boiler = $cf -> get('boiler_ot');
				exit(json_encode(array('response' => true, 'data' => $conf_boiler)));
			break;

			case 'boiler_ot_cfg_save':

				$obj2save = json_decode(base64_decode($C), true);
				
				if(is_array($obj2save))
				{
					$cf = new configuration(CONFIGURATION_FILE);
					$conf_boiler = $cf -> get('boiler_ot');

					$mapObj = array('temp.rano' => 'tr', 'temp.dzien' => 'td', 'temp.wieczor' => 'tw', 'temp.noc' => 'tn', 'kg.n' => 'kn', 'kg.s' => 'ks');			
					$new = arrays2do :: map_values($conf_boiler, $obj2save, $mapObj, true, true);
					
					$cf -> save_simple_element('boiler_ot', $new);

					exit(json_encode(array('response' => true, 'data' => 'ok')));
				}

				exit(json_encode(array('response' => true, 'data' => 'err')));

			break;

			case 'boiler_ot_hours_save':

				$obj2save = json_decode(base64_decode($C), true);
				
				if(is_array($obj2save))
				{
					$cf = new configuration(CONFIGURATION_FILE);
					$conf_boiler = $cf -> get('boiler_ot');

					$mapObj = array();

					for($i=1; $i<=7; $i++){
						$mapObj['hours.'.$i.'.rano'] = 'h'.$i.'r'; $mapObj['hours.'.$i.'.dzien'] = 'h'.$i.'d'; $mapObj['hours.'.$i.'.wieczor'] = 'h'.$i.'w'; $mapObj['hours.'.$i.'.noc'] = 'h'.$i.'n';
					}
					
					$new = arrays2do :: map_values($conf_boiler, $obj2save, $mapObj, true, false);					
										
					$cf -> save_simple_element('boiler_ot', $new);

					exit(json_encode(array('response' => true, 'data' => 'ok')));
				}

				exit(json_encode(array('response' => true, 'data' => 'err')));

			break;
		}

	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'cameras':

		include_once('inc/cameras.php');

	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	case 'list_elements':

		$menu = array();

		if($B == 'print_values')
		{
			$menu['Pokaż elementy'] = 'index.php?a=list_elements';

			$ret = pt :: command('read_write', '--read-all--');
			
			echo html :: header('Odczyt wartości', array('menu' => $menu));
			
			$obj = json_decode($ret, true);

			$ret1 = array();
			$ret2 = array();
			$ret3 = array();

			foreach($obj as $k => $v)
			{
				if(substr($k, 0, 1) == '_')
					$ret1[$k] = $v;
				else if(strpos($k, '.') > 0)
					$ret2[$k] = $v;
				else
					$ret3[$k] = $v;
			}


			ksort($ret2);
			
			$s1= '<div class="tbl view">';
			foreach($ret1 as $k => $v)
				$s1 .= '<div class="tr"><div class="td">'.$k.'</div><div class="td">'.$v.'</div></div>';
			$s1 .=  '</div>';

			$s2= '<div class="tbl view">';
			foreach($ret2 as $k => $v)
				$s2 .= '<div class="tr"><div class="td">'.$k.'</div><div class="td">'.$v.'</div></div>';
			$s2 .=  '</div>';			

			$s3= '<div class="tbl view">';
			foreach($ret3 as $k => $v)
				$s3 .= '<div class="tr"><div class="td">'.$k.'</div><div class="td">'.$v.'</div></div>';
			$s3 .=  '</div>';	

			echo '<div class="tbl view">
			<div class="td t" style="width:33%">'.$s3.'</div>
			<div class="td t">'.$s2.'</div>
			<div class="td t" style="width:33%">'.$s1.'</div>
			</div>';
			
			echo html :: footer();			
		}
		else
		{
			$menu['Pokaż listę wartości'] = 'index.php?a=list_elements&b=print_values';

			echo html :: header('Widok elementów', array('menu' => $menu, 'disp_importants' => true));

			echo html :: mk_elem($CONFIG);

			echo html :: footer();
		}

	break;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	
	default:
		
		$links = array();

		if($B == 'show_values')
		{
			$links['Pokaż opisy'] = 'index.php';	
			define('SHOW_VALUES', true);
		}
		else
			$links['Pokaż wartości'] = 'index.php?b=show_values';		

		define('IS_CONTENT', true);

		$MODULES_START = modules :: get_diagram_elem();
		//echo '<pre style="font-family:verdana;font-size:10px;">'.print_r($MODULES_START, true).'</pre>';die;

		echo html :: header('Start', array('menu' => $links, 'disp_importants' => $B == 'show_values'));

		include_once('inc/start_diagram.php');

		echo html :: footer();				

}

class arrays2do
{
	public static function map_values($obj, $updateObj, $insertList, $watch = false, $watchLen = false)
	{		
		foreach($insertList as $k => $v)
		{
			list($_a, $_b, $_c) = explode('.', $k . '...');

			$val = arr :: getm($updateObj, $v, '');

			if($_c > '')
			{
				if(!$watch && !isset($obj[$_a]))
					$obj[$_a] = array();

				if(!$watch && !isset($obj[$_a][$_b]))
					$obj[$_a][$_b] = array();
				
				if(($watch && isset($obj[$_a][$_b][$_c])) || !$watch)
				{
					if(($watchLen && $val > '') || !$watchLen)
						$obj[$_a][$_b][$_c] = $val;
				}
			}
			else if($_b > '')
			{
				if(!$watch && !isset($obj[$_a]))
					$obj[$_a] = array();

				if(($watch && isset($obj[$_a][$_b])) || !$watch)
				{
					if(($watchLen && $val > '') || !$watchLen)
						$obj[$_a][$_b] = arr :: getm($updateObj, $v);
				}
			}
			else
			{
				if(($watch && isset($obj[$_a])) || !$watch)
				{
					if(($watchLen && $val > '') || !$watchLen)
						$obj[$_a] = arr :: getm($updateObj, $v);
				}
			}
		}

		return $obj;
	}
}

?>