<?php

class configuration
{
	private $dataFile = null;
	//private $pingScript;

	private static $actions = array(
		'shutdown' => 'wyłącz malinę',
		'restart' => 'restartuj malinę',
		'ihome_data_set' => 'Wyślij dane do iHome / st.',
		'ihome_data_write' => 'Wyślij dane do iHome / dyn.',
		'http_open' => 'Otwórz adres url',
		'out_d_1' => 'Wyjście ustaw na 1',
		'out_d_0' => 'Wyjście ustaw na 0',
		'out_d_toggle' => 'Zmień stan wyjścia',
		'send_command' => 'Wyslij komendę lub wartość',
		'device_start' => 'Włącz urządzenie',
		'device_stop' => 'Wyłącz urządzenie',
		'run_task' => 'Wykonaj zadania',
		'save2sysnote' => 'Zapisz do kontenera wiadomości'
	);

	private static $spec_variables = array(
		'sunshine' => array('nazwa' => 'status słońca', 'opis' => 'status słońca - wyliczany wg algorytmu: 1 jak w dzień, 0 w nocy'),
		'hour' => array('nazwa' => 'aktualna godzina', 'opis' => ''),
		'weather_temperature' => array('nazwa' => 'temperatura wg. OpenWeathermap', 'opis' => ''),
		//'err_sys_conections' => array('nazwa' => 'błędy połaczeń', 'opis' => '')
	);
	private static $sys_err_variables = array(
		'err_connections' => array('nazwa' => 'błąd połączeń z zewnętrznymi urządzeniami', 'opis' => ''),
		'err_modules' => array('nazwa' => 'błąd modułu', 'opis' => '')
	);	

	private static $rflink_actions = array(
		'ON' => 'ON'
	);

	private static $gpio_types = array(
		'out_d_0' => 'Wyjście cyfrowe (on=1)',
		'pwm' => 'PWM',
		'ds18b20' => 'czujnik ds18b20',
		'input_d_1' => 'Wejście logiczne, podcignięte do plusa',
		//'rflink' => 'RFLink',
	);

	private static $gpioList = array(
		2 => 'sda',
		3 => 'scl',
		4 => '',
		17 => '',
		27 => '',
		22 => '',
		10 => '',
		9 => '',
		11 => '',
		5 => '',
		6 => '',
		13 => '',
		19 => '',
		26 => '',
		14 => 'tx',
		15 => 'rx',
		18 => '',
		23 => '',
		24 => '',
		25 => '',
		8 => '',
		7 => '',
		4 => '',
		12 => '',
		16 => '',
		20 => '',
		21 => '',
	);

	private static $devices_out = array(		
		'comp' => 'Komputer',
		//'lk1' => 'Lan Kontroler 1',
		'lk2' => 'Lan Kontroler 2',
		'lk3' => 'Lan Kontroler 3',
		'afe_1ch' => 'AFE Firmware - 1ch',
		'afe_1ch_v3' => 'AFE Firmware - 1ch - api v3',
		'arduino-v1' => 'Arduino simple',
	);	

	private static $templates = array(

		'parameters' => array(
			'access' => array('name' => 'Autoryzacja', 'fields' => array(
				'user' => array('name' => 'Użytkownik'),
				'passwd' => array('name' => 'Hasło'),
			)),
			'main' => array('name' => 'Ogólne', 'fields' => array(
				'ram_disk_path' => array('name' => 'Scieżka do dysku ram'),
				'device_addr' => array('name' => 'Adres IP', 'pattern' => '([0-9\.]{7,15})|(localhost)', 'desc' => 'lub localhost'),
				'broadcast_ip' => array('name' => 'Adres rozgłoszeniowy', 'pattern' => '[0-9\.]{7,15}'),
				//'wake_up_port' => array('name' => 'Port wake up'),
			)),
			'idents' => array('name' => 'Identyfikatory', 'fields' => array(
				'ihome_ident' => array('name' => 'Home - identyfikator klienta'),
				'ihome_key' => array('name' => 'iHome - klucz'),
				'openweathermap_key' => array('name' => 'OpenWeathermap - API key', 'desc' => ''),
				'localization_lat' => array('name' => 'Współrzędne - LAT', 'desc' => ''),
				'localization_long' => array('name' => 'Współrzędne - LONG', 'desc' => ''),
			)),	
			'mqtt' => array('name' => 'Serwer MQTT',
				'desc' => 'Dane dostępowe do głównego brokera MQTT.<br>Tematy układane sa w następujący sposób:<br>prefix/identyfikator_urządzenia/...',
				'fields' => array(
					'aktywny' => array('name' => 'Czy aktywny', 'type' => 'checked'),
					'server' => array('name' => 'MQTT - adres serwara'),
					'port' => array('name' => 'MQTT - port'),
					'prefix' => array('name' => 'MQTT - prefix'),
					'ident' => array('name' => 'MQTT - identyfikator'),
					'user' => array('name' => 'MQTT - użytkownik'),
					'passwd' => array('name' => 'MQTT - hasło'),
			)),
			'mqtt_send' => array('name' => 'Serwer MQTT - tylko do wysyłania',
				'desc' => 'Dane dostępowe do zapasowego brokera MQTT.<br>Obecnie służy on tylko do wysyłania danych (zdjęć) z kamer, o ile główny MQTT nie jest ustawiony.<br>Tematy układane sa w następujący sposób:<br>prefix/identyfikator_urządzenia/...',
				'fields' => array(
					'aktywny' => array('name' => 'Czy aktywny', 'type' => 'checked'),
					'server' => array('name' => 'MQTT - adres serwara'),
					'port' => array('name' => 'MQTT - port'),
					'prefix' => array('name' => 'MQTT - prefix'),
					'ident' => array('name' => 'MQTT - identyfikator'),
					'user' => array('name' => 'MQTT - użytkownik'),
					'passwd' => array('name' => 'MQTT - hasło'),
			)),	
			'oled' => array('name' => 'Wyświetlacz OLED', 'fields' => array(
				'display_addr' => array('name' => 'Wyświetlacz OLED - adres', 'desc' => '0,96 / SSD1306 - format szesnastkowy '),
				'display_options' => array('name' => 'Wyświetlacz OLED - co pokazywać', 'type' => 'checkboxes', 'desc' => '', 'options' => 
					array('ip' => 'adres IP', 'cpu' => 'Użycie procesora', 'mem' => 'Zużycie pamięci', 'disk' => 'informacje o dysku'))
			)),
			'rs485' => array('name' => 'RS485', 'fields' => array(
				'aktywny' => array('name' => 'Czy aktywny', 'type' => 'checked'),
				'port' => array('name' => 'Konfiguracja portu', 'type' => 'arr', 'options' => array('numer' => 'Numer', 'predkosc' => 'Prędkość', 'czas' => 'Czas - timeout')),				
				'cmd' => array('name' => 'Komenda cykliczna - parametry', 'type' => 'arr', 'options' => array(
					'dlugosc' => 'długość łańcucha znaków', 'znak_p' => 'znak początkowy', 'znak_k' => 'znak końcowy', 'znak_r' => 'znak rozdzielający')
				),
				'pin_kierunek' => array('name' => 'Kierunek pinu', 'type' => 'number', 'desc' => 'Wymagany jak sterownik potrzebuje zmainy napięcia w momencie nadawania'),
			)),
			'rflink' => array('name' => 'RFLink', 'fields' => array(
				'aktywny' => array('name' => 'Czy aktywny', 'type' => 'checked'),
				'port' => array('name' => 'Port RFLink'),
			)),
			'zigbee' => array('name' => 'Zigbee', 'fields' => array(
				'mqtt_server' => array('name' => 'MQTT - Adres serwera'),
				'mqtt_port' => array('name' => 'MQTT - Port'),
				'mqtt_user' => array('name' => 'MQTT - Użytkownik'),
				'mqtt_passwd' => array('name' => 'MQTT - Hasło'),
				'www_port' => array('name' => 'Port usługi www', 'pattern' => '[0-9]{1,}'),
			))
		),
		/*
		'parameters' => array(
			'ram_disk_path' => array('name' => 'Scieżka do dysku ram'),
			//'device_ip' => array('name' => 'Adres IP', 'pattern' => '[0-9\.]{7,15}'),
			'broadcast_ip' => array('name' => 'Adres rozgłoszeniowy', 'pattern' => '[0-9\.]{7,15}'),
			//'wake_up_port' => array('name' => 'Port wake up'),
			'ihome_ident' => array('name' => 'Home - identyfikator klienta'),
			'ihome_key' => array('name' => 'iHome - klucz'),
			array('type' => 'sep', 'name' => 'MQTT'),
			'mqtt_server' => array('name' => 'MQTT - adres serwara'),
			'mqtt_port' => array('name' => 'MQTT - port'),
			'mqtt_prefix' => array('name' => 'MQTT - prefix'),
			'mqtt_ident' => array('name' => 'MQTT - identyfikator'),
			'mqtt_user' => array('name' => 'MQTT - użytkownik'),
			'mqtt_passwd' => array('name' => 'MQTT - hasło'),
			array('type' => 'sep', 'name' => 'Wyświetlacz OLED'),
			'oled_display_addr' => array('name' => 'Wyświetlacz OLED - adres', 'desc' => '0,96 / SSD1306 - format szesnastkowy '),
			'oled_display_options' => array('name' => 'Wyświetlacz OLED - co pokazywać', 'type' => 'checkboxes', 'desc' => '', 'options' => 
				array('ip' => 'adres IP', 'cpu' => 'Użycie procesora', 'mem' => 'Zużycie pamięci', 'disk' => 'informacje o dysku')),
			array('type' => 'sep', 'name' => 'RFLink Geteway'),
			'rflink_port' => array('name' => 'Port RFLink'),
			array('type' => 'sep', 'name' => 'Zigbee'),
				'zigbee_mqtt_server' => array('name' => 'MQTT - adres serwera'),
				'zigbee_mqtt_port' => array('name' => 'MQTT - port'),
				'zigbee_mqtt_user' => array('name' => 'MQTT - użytkownik'),
				'zigbee_mqtt_passwd' => array('name' => 'MQTT - hasło'),
		),
		*/

		'variables' => array(
			'nazwa' => array('name' => 'Nazwa zmiennej', 'pattern' => '[a-zA-Z0-9_\-]{2,}'),
			'opis' => array('name' => 'Opis'),
			'opis_1' => array('name' => 'Opis pełny', 'type' => 'textarea'),
			'typ' => array('name' => 'Typ', 'type' => 'select', 'options' => array('yn' => 'tak/nie', 'text' => 'tekstowa', 'number' => 'numer', 'time' => 'godzinia:minuta', 'counter' => 'licznik', 'exp' => 'zmienna wyliczana')),
			//'conditional' => 'zmienna warunkowa',
			//'if_zawiera' => array('name' => 'If wartość zawiera', 'avail' => 'typ:conditional', 'type' => 'textarea', 'desc' => 'np: zmienna=1;zmienna>2;...', 'help' => 'def:variable_conditional'),
			/*
			'-1' => array('type' => '_elem_start', 'count' => 'two'),
			'warunek_lub' => array('name' => 'Warunek lub', 'avail' => 'typ:conditional', 'type' => 'checked'),
			'wyrazenie' => array('name' => 'Ustaw zmienną na:', 'avail' => 'typ:conditional', 'type' => 'select', 'options' => array(
				'n1' => 'Ustaw na 1 jak nie to 0', 'n0' => 'Ustaw na 0 jak nie to 1'
			)),			
			'-2' => array('type' => '_elem_end'),
			*/
			'reg' => array('name' => 'Wyrażenie ', 'avail' => 'typ:exp', 'type' => 'textarea', 'desc' => '$zmienna + $zmienna lub 1 if $zmienna1=3 else 2', 'help' => 'def:variable_exp'),
			'number_val' => array('name' => 'Przeliczanie zmiennej', 'avail' => 'typ:exp', 'type' => 'arr', 'options' => array(
				//'reg' => 'wyrażenie np: $zmn1 + $zmn2',
				'proc_min' => 'przelicz - procentowo min', 'proc_max' => 'przelicz - procentowo max'
			), 'desc' => 'np zmienna=%f - dla float, lub %i dla integer, find:1:0', 'help' => 'def:proc_min_max'),
		),

		'devices' => array(
			//'nazwa' => array('name' => 'Nazwa urządzenia', 'pattern' => '[a-zA-Z0-9_\-]{2,}'),
			'_na' => array('Nazwa urządzenia'),

			'opis' => array('name' => 'Opis'),
			'opis_1' => array('name' => 'Opis pełny', 'type' => 'textarea'),
			
			'typ' => array('name' => 'Typ', 'type' => 'select', 'options' => 'get_val:self:devices_out'),
			'ip' => array('name' => 'Adres IP', 'avail' => 'typ:comp,afe_1ch,afe_1ch_v3,lk2,lk3,arduino-v1'),
			'afe' => array('type' => 'arr', 'options' => array('device' => 'Device', 'name' => 'Name'), 'avail' => 'typ:afe_1ch,afe_1ch_v3'),
			'access' => array('type' => 'arr', 'options' => array('login' => 'Login', 'passwd' => 'Hasło'), 'avail' => 'typ:afe_1ch,afe_1ch_v3,lk2,lk3,arduino-v1'),
			'port' => array('name' => 'Port', 'desc' => 'port przekaźnika domyślnie: 80', 'avail' => 'typ:afe_1ch,afe_1ch_v3,lk2,lk3,arduino-v1'),
			'mac' => array('name' => 'Adres MAC', 'avail' => 'typ:comp'),
			'param' => array('name' => 'Dla LK list pól branych po uwagę rozdzielanych ;', 'avail' => 'typ:lk2,lk3,arduino-v1', 'type' => 'textarea', 'css' => ['height:100px'])
		),

		'cameras' => array(
			'_na' => array('Nazwa kamery'),

			'opis' => array('name' => 'Opis'),
			'opis_1' => array('name' => 'Opis pełny', 'type' => 'textarea'),
			
			'url' => array('name' => 'Adres do kamery'),
			'access' => array('type' => 'arr', 'options' => array('login' => 'Login', 'passwd' => 'Hasło')),			
			'crop' => array('name' => 'Przycinanie obrazu', 'type' => 'arr', 'options' => array(
				'x' => 'x [%]',
				'y' => 'y [%]',
				'w' => 'dłogość  [%]',
				'h' => 'wysokość  [%]',
				'r' => 'Obrót [kąt]'
			), 'desc' => 'asdadada', 'help' => '')
		),		

		'gpio' => array(
			'nazwa' => array('name' => 'Nazwa pinu lub elementu', 'pattern' => '[a-zA-Z0-9_\-]{2,}'),
			'opis' => array('name' => 'Opis'),
			'opis_1' => array('name' => 'Opis pełny', 'type' => 'textarea'),
			'typ' => array('name' => 'Typ', 'type' => 'select', 'options' => 'get_val:self:gpio_types'),
			//'numer' => array('name' => 'Numer pinu / GPIO', 'type' => 'number', 'avail' => 'typ:out_d_0,input_d_1,pwm'),
			'numer' => array('name' => 'Numer pinu / GPIO', 'type' => 'select', 'options' => 'get_var:gpio_list', 'avail' => 'typ:out_d_0,input_d_1,pwm'),
			'mac' => array('name' => 'Adres MAC', 'type' => 'text', 'desc' => 'Np dla czujnika ds18B20', 'avail' => 'typ:ds18b20'),
			'czestotliwosc' => array('name' => 'Częstotliwość', 'type' => 'number', 'desc' => '', 'avail' => 'typ:pwm'),
			'czas' => array('name' => 'Czas pozostawania w danej aktywności', 'type' => 'number', 'desc' => '', 'avail' => 'typ:out_d_0'),
		),

		'rflink' => array(
			//'nazwa' => array('name' => 'Nazwa pinu lub elementu', 'pattern' => '[a-zA-Z0-9_\-]{2,}'),
			'_na' => array('Nazwa urządzenia'),
			'opis' => array('name' => 'Opis'),
			'opis_1' => array('name' => 'Opis pełny', 'type' => 'textarea'),
			'protokol' => array('name' => 'Protokół', 'type' => 'text', 'desc' => ''),
			'id' => array('name' => 'ID', 'type' => 'text', 'desc' => 'pojedyncza wartość lub elementy rozdzielane ;'),
			'numer' => array('name' => 'Numer', 'type' => 'text', 'desc' => ''),
			'komendy' => array('name' => 'Komendy', 'type' => 'text', 'desc' => 'możliwe komendy rozdzielone średnikiem np: ON/OFF/ALLON/ALLOFF/UP/DOWN/STOP', 'help' => ''),
			'-1' => array('type' => '_odst'),
			'wyrazenie' => array('name' => 'If wartość zawiera', 'avail' => 'typ:element', 'type' => 'arr', 'options' => array(
				'nie' => 'Ustaw na 0', 'tak' => 'Ustaw na 1'
			), 'desc' => 'Dotyczy całego ciągu znaków odbieranego z urządzenia'),
			'number_val' => array('name' => 'Wartość liczbowa', 'type' => 'arr', 'options' => array(
				'reg' => 'wyrażenie, %if',
				'proc_min' => 'przelicz - procentowo min',
				'proc_max' => 'przelicz - procentowo max',
				//'watch_step' => 'sprawdzaj przyrost'
			), 'desc' => 'np zmienna=%f - dla float, lub %i dla integer, find:1:0', 'help' => 'def:expression,proc_min_max')
		),

		'ports' => array(
			'nazwa' => array('name' => 'Nazwa', 'pattern' => '[a-zA-Z0-9_\-]{2,}'),			
			'opis' => array('name' => 'Opis'),
			'opis_1' => array('name' => 'Opis pełny', 'type' => 'textarea'),
			'typ' => array('name' => 'Rodzaj', 'type' => 'select', 'options' => ['definicja' => 'Definicja', 'element' => 'Stan lub komenda do wysłania']),
			'rodzaj' => array('name' => 'Typ', 'type' => 'select', 'options' => ['serial' => 'Serial port'], 'avail' => 'typ:definicja'),
			'port' => array('type' => 'arr', 'options' => array('numer' => 'Numer', 'predkosc' => 'Prędkość', 'czas' => 'Czas - timeout'), 'avail' => 'typ:definicja'),
			'definicja' => array('name' => 'Definicja', 'type' => 'select', 'avail' => 'typ:element', 'options' => 'get_var:ports_def'),
			'wyrazenie' => array('name' => 'If wartość zawiera', 'avail' => 'typ:element', 'type' => 'arr', 'options' => array('nie' => 'Ustaw na 0', 'tak' => 'Ustaw na 1')),
		),

		'rs485' => array(
			//'nazwa' => array('name' => 'Nazwa', 'pattern' => '[a-zA-Z0-9_\-]{2,}'),
			'_na' => array('Nazwa urządzenia'),
			'opis' => array('name' => 'Opis'),
			'opis_1' => array('name' => 'Opis pełny', 'type' => 'textarea'),
			'typ' => array('name' => 'Rodzaj', 'type' => 'select', 'options' => ['definicja' => 'Definicja urządzenia', 'element' => 'Stan lub komenda do wysłania']),

			'definicja' => array('name' => 'Definicja', 'type' => 'select', 'avail' => 'typ:element', 'options' => 'get_var:rs485_def'),
			'ident' => array('name' => 'Identyfikator', 'type' => 'text', 'avail' => 'typ:element'),

			'urzadzenie_nazwa' => array('name' => 'Nazwa urządzenia', 'avail' => 'typ:definicja'),
			
			'wyrazenie' => array('name' => 'If wartość zawiera', 'avail' => 'typ:element', 'type' => 'arr', 'options' => array(
				'nie' => 'Ustaw na 0', 'tak' => 'Ustaw na 1'
			), 'desc' => ''),
			'number_val' => array('name' => 'Wartość liczbowa', 'avail' => 'typ:element', 'type' => 'arr', 'options' => array(
				'reg' => 'wyrażenie, %if',
				'proc_min' => 'przelicz - procentowo min',
				'proc_max' => 'przelicz - procentowo max',
				'watch_step' => 'sprawdzaj przyrost'
			), 'desc' => 'np zmienna=%f - dla float, lub %i dla integer, find:1:0, przyrost - wartość jak i o ile ma sprawdzać', 'help' => 'def:expression,proc_min_max,watch_step')
		),

		'zigbee' => array(
			'_na' => array('Nazwa urządzenia'),
			'opis' => array('name' => 'Opis'),
			'opis_1' => array('name' => 'Opis pełny', 'type' => 'textarea'),
			'typ' => array('name' => 'Typ', 'type' => 'select', 'options' => ['pk' => 'Przekaźnik, gniazdko, ...', 'sensor' => 'Czujnik']),
			//'ident' => array('name' => 'Identyfikator', 'type' => 'text', 'desc' => 'Nazwa urządzenia w zigbe2mqtt'),
			/*
			'wyrazenie' => array('name' => 'If wartość zawiera', 'avail' => 'typ:element', 'type' => 'arr', 'options' => array(
				'nie' => 'Ustaw na 0', 'tak' => 'Ustaw na 1'
			), 'desc' => ''),
			*/

			'device_name' => array('name' => 'Nazwa urządzenia'),
			'variable_name' => array('name' => 'Nazwa zmiennej'),

			'wyrazenie' => array('name' => 'If wartość zawiera', 'avail-?sdfs' => 'typ:element', 'type' => 'arr', 'options' => array(
				'nie' => 'Ustaw na 0', 'tak' => 'Ustaw na 1'
			), 'desc' => ''),
			'number_val' => array('name' => 'Wartość liczbowa', 'avail-?df' => 'typ:element', 'type' => 'arr', 'options' => array(
				'reg' => 'wyrażenie, %if',
				'proc_min' => 'przelicz - procentowo min',
				'proc_max' => 'przelicz - procentowo max',
				'watch_step' => 'sprawdzaj przyrost'
			), 'desc' => 'np zmienna=%f - dla float, lub %i dla integer, find:1:0, przyrost - wartość jak i o ile ma sprawdzać', 'help' => 'def:expression,proc_min_max,watch_step')

		),

		'i2c' => array(
			//'nazwa' => array('name' => 'Nazwa', 'pattern' => '[a-zA-Z0-9_\-]{2,}'),			
			'_na' => array('Nazwa'),
			'opis' => array('name' => 'Opis'),
			'opis_1' => array('name' => 'Opis pełny', 'type' => 'textarea'),
			'typ' => array('name' => 'Rodzaj', 'type' => 'select', 'options' => ['definicja' => 'Definicja', 'element' => 'Stan lub komenda do wysłania']),
			//'rodzaj' => array('name' => 'Typ', 'type' => 'select', 'options' => ['serial' => 'Serial port'], 'avail' => 'typ:definicja'),
			'adres' => array('name' => 'Adres portu', 'avail' => 'typ:definicja', 'desc' => 'format 0x00'),
			'definicja' => array('name' => 'Definicja', 'type' => 'select', 'avail' => 'typ:element', 'options' => 'get_var:i2c_def'),
			'wyrazenie' => array('name' => 'If wartość zawiera', 'avail' => 'typ:element', 'type' => 'arr', 'options' => array(
				'nie' => 'Ustaw na 0', 'tak' => 'Ustaw na 1'
			), 'desc' => ''),
			'number_val' => array('name' => 'Wartość liczbowa', 'avail' => 'typ:element', 'type' => 'arr', 'options' => array(
				'reg' => 'wyrażenie, %if', 'proc_min' => 'przelicz - procentowo min', 'proc_max' => 'przelicz - procentowo max'
			), 'desc' => ''),
		),

		'time' => array(
			//'nazwa' => array('name' => 'Nazwa pinu lub elementu', 'pattern' => '[a-zA-Z0-9_\-]{2,}'),
			'_na' => array('Nazwa zdarzenia'),
			'opis' => array('name' => 'Opis'),
			'typ' => array('name' => 'Typ', 'type' => 'select', 'options' => array('every' => 'co określony czas', 'time' => 'o określonej godzinie')),
			'-1' => array('type' => '_elem_start', 'count' => 'two'),
			'parametr' => array('name' => 'Parametr', 'type' => 'text', 'desc' => 'ilośc minut lub czas w formacie gg:mm'),
			'parametr_var' => array('name' => 'lub Parametr - zmienna', 'type' => 'select', 'options' => 'get_var:variables_time'),
			'-2' => array('type' => '_elem_end'),

			'lacznik0' => array('name' => 'dodatkowo', 'type' => 'select', 'options' => array('and' => 'i')),
			
			'-3' => array('type' => '_elem_start', 'count' => 'two'),
			'if1' => array('name' => 'Nazwa pola 1', 'type' => 'select', 'options' => 'get_var:all_fields', 'avail' => 'lacznik0:and'),
			'warunek1' => array('name' => 'Rodzaj warunku 1', 'type' => 'select', 'options' => array( '>' => '&gt;', '=' => '=','<' => '&lt;', '~' => 'zawiera'), 'avail' => 'lacznik0:and'),
			'-4' => array('type' => '_elem_end'),			
			'-5' => array('type' => '_elem_start', 'count' => 'two'),
			'wartosc1' => array('name' => 'Wartość', 'type' => 'text', 'avail' => 'lacznik0:and'),
			'wartosc1_var' => array('name' => 'lub wartość zmiennej', 'type' => 'select', 'options' => 'get_var:variables', 'avail' => 'lacznik0:and'),
			'-6' => array('type' => '_elem_end'),

			'lacznik1' => array('name' => 'i / lub', 'type' => 'select', 'options' => array('and' => 'i', 'or' => 'lub'), 'avail' => 'lacznik0:and'),

			'-7' => array('type' => '_elem_start', 'count' => 'two'),
			'if2' => array('name' => 'Nazwa pola 2', 'type' => 'select', 'options' => 'get_var:all_fields', 'avail' => 'lacznik1:and,or'),
			'warunek2' => array('name' => 'Rodzaj warunku 2', 'type' => 'select', 'options' => array( '>' => '&gt;', '=' => '=','<' => '&lt;', '~' => 'zawiera'), 'avail' => 'lacznik1:and,or'),
			'-8' => array('type' => '_elem_end'),			
			'-9' => array('type' => '_elem_start', 'count' => 'two'),
			'wartosc2' => array('name' => 'Wartość', 'type' => 'text', 'avail' => 'lacznik1:and,or'),
			'wartosc2_var' => array('name' => 'lub wartość zmiennej', 'type' => 'select', 'options' => 'get_var:variables', 'avail' => 'lacznik1:and,or'),
			'-10' => array('type' => '_elem_end'),
			
			'akcja' => array('name' => 'Akcja', 'type' => 'select', 'options' => 'get_val:self:actions'),
			'komenda_cel' => array('name' => 'Nazwa pola', 'type' => 'select', 'options' => 'get_var:all_cmd_def_var', 'avail' => 'akcja:send_command'),
			'akcja_parametr' => array('name' => 'Parametr', 'type' => 'text', 'avail' => 'akcja:ihome_data_set,ihome_data_write,send_command,http_open,save2sysnote'),
			'akcja_parametr_out' => array('name' => 'Nazwa pola', 'type' => 'select', 'options' => 'get_var:outs', 'avail' => 'akcja:out_d_1,out_d_0,out_d_toggle'),
			'urzadzenie' => array('name' => 'Nazwa urządzenia', 'type' => 'select', 'options' => 'get_var:devices', 'avail' => 'akcja:device_start,device_stop'),
			'zadanie' => array('name' => 'Zadanie', 'type' => 'select', 'options' => 'get_var:tasks_list', 'avail' => 'akcja:run_task'),
			'nie_loguj' => array('name' => 'Nie dodawaj do logów', 'type' => 'checked'),
		),

		'events' => array(
			//'nazwa' => array('name' => 'Nazwa zdarzenia', 'pattern' => '[a-zA-Z0-9_\-]{2,}'),
			'_na' => array('Nazwa zdarzenia'),
			'opis' => array('name' => 'Opis'),

			'-1' => array('type' => '_elem_start', 'count' => 'three'),
			'if1' => array('name' => 'Pole 1', 'type' => 'select', 'options' => 'get_var:all_fields'),
			'warunek1' => array('name' => 'Warunek 1', 'type' => 'select', 'options' => array( '>' => '&gt;', '=' => '=','<' => '&lt;', '~' => 'zawiera')),
			//'histereza1' => array('name' => 'Histereza 1', 'avail' => 'warunek1:>,<'),
			'-2' => array('type' => '_elem_end'),			
			'-3' => array('type' => '_elem_start', 'count' => 'two'),
			'wartosc1' => array('name' => 'Wartość', 'type' => 'text'),
			'wartosc1_var' => array('name' => 'lub wartość zmiennej', 'type' => 'select', 'options' => 'get_var:variables'),
			'-4' => array('type' => '_elem_end'),
			
			'lacznik1' => array('name' => 'i / lub', 'type' => 'select', 'options' => array('and' => 'i', 'or' => 'lub')),

			'-5' => array('type' => '_elem_start', 'count' => 'three'),			
			'if2' => array('name' => 'Pole 2', 'type' => 'select', 'options' => 'get_var:all_fields', 'avail' => 'lacznik1:and,or'),
			'warunek2' => array('name' => 'Warunek 2', 'type' => 'select', 'options' => array( '>' => '&gt;', '=' => '=','<' => '&lt;', '~' => 'zawiera'), 'avail' => 'lacznik1:and,or'),
			//'histereza2' => array('name' => 'Histereza 2', 'avail' => 'warunek2:>,<'),
			'-6' => array('type' => '_elem_end'),
			'-7' => array('type' => '_elem_start', 'count' => 'two'),			
			'wartosc2' => array('name' => 'Wartość', 'type' => 'text', 'avail' => 'lacznik1:and,or'),
			'wartosc2_var' => array('name' => 'lub wartość zmiennej', 'type' => 'select', 'options' => 'get_var:variables', 'avail' => 'lacznik1:and,or'),
			'-8' => array('type' => '_elem_end'),
			
			'lacznik2' => array('name' => 'i / lub', 'type' => 'select', 'options' => array('and' => 'i', 'or' => 'lub'), 'avail' => 'lacznik1:and,or'),

			'-9' => array('type' => '_elem_start', 'count' => 'three'),
			'if3' => array('name' => 'Pole 3', 'type' => 'select', 'options' => 'get_var:all_fields', 'avail' => 'lacznik2:and,or'),
			'warunek3' => array('name' => 'Warunek 3', 'type' => 'select', 'options' => array( '>' => '&gt;', '=' => '=','<' => '&lt;', '~' => 'zawiera'), 'avail' => 'lacznik2:and,or'),
			//'histereza3' => array('name' => 'Histereza 3', 'avail' => 'warunek3:>,<'),
			'-10' => array('type' => '_elem_end'),
			'-11' => array('type' => '_elem_start', 'count' => 'two'),			
			'wartosc3' => array('name' => 'Wartość', 'type' => 'text', 'avail' => 'lacznik2:and,or'),
			'wartosc3_var' => array('name' => 'lub wartość zmiennej', 'type' => 'select', 'options' => 'get_var:variables', 'avail' => 'lacznik2:and,or'),
			'-12' => array('type' => '_elem_end'),
			
			'akcja' => array('name' => 'Akcja', 'type' => 'select', 'options' => 'get_val:self:actions'),
			'komenda_cel' => array('name' => 'Nazwa pola', 'type' => 'select', 'options' => 'get_var:all_cmd_def_var', 'avail' => 'akcja:send_command'),
			'akcja_parametr' => array('name' => 'Parametr', 'type' => 'text', 'avail' => 'akcja:ihome_data_set,ihome_data_write,send_command,http_open,save2sysnote'),
			'akcja_parametr_out' => array('name' => 'Nazwa pola', 'type' => 'select', 'options' => 'get_var:outs', 'avail' => 'akcja:out_d_1,out_d_0,out_d_toggle'),			
			'zadanie' => array('name' => 'Zadanie', 'type' => 'select', 'options' => 'get_var:tasks_list', 'avail' => 'akcja:run_task'),
			'urzadzenie' => array('name' => 'Nazwa urządzenia', 'type' => 'select', 'options' => 'get_var:devices', 'avail' => 'akcja:device_start,device_stop'),			
			
			'-13' => array('type' => '_elem_start', 'count' => 'four'),
			'zablokuj' => array('name' => 'Zablokuj / odblokuj', 'type' => 'checked', 'desc' => 'po zmianie danych i czasie'),
			'nie_loguj' => array('name' => 'Nie dodawaj do logów', 'type' => 'checked'),
			'zablokuj_czas' => array('name' => 'Blokuj zdarzenie po wystąpieniu przez czas [s]', 'type' => 'number'),
			'zablokuj_start' => array('name' => 'Blokuj zdarzenie przez 60 sekund po uruchomieniu systemu', 'type' => 'checked'),			
			'-14' => array('type' => '_elem_end'),
		),

		'tasks' => array(
			//'nazwa' => array('name' => 'Nazwa zdarzenia', 'pattern' => '[a-zA-Z0-9_\-]{2,}'),
			'_na' => array('Nazwa zdarzenia'),
			'opis' => array('name' => 'Opis'),

			'-11' => array('type' => '_odst'),
			
			'-1' => array('type' => '_flex_start', 'count' => 'four'),
				'akcja_1' => array('name' => 'Akcja 1', 'type' => 'select', 'options' => 'get_val:self:actions'),
				'komenda_cel_1' => array('name' => 'Nazwa pola', 'type' => 'select', 'options' => 'get_var:all_cmd_def_var', 'avail' => 'akcja_1:send_command'),			
				'akcja_parametr_out_1' => array('name' => 'Nazwa wyjścia', 'type' => 'select', 'options' => 'get_var:outs', 'avail' => 'akcja_1:out_d_1,out_d_0,out_d_toggle'),	
				'urzadzenie_1' => array('name' => 'Nazwa urządzenia', 'type' => 'select', 'options' => 'get_var:devices', 'avail' => 'akcja_1:device_start,device_stop'),		
				'akcja_parametr_1' => array('name' => 'Parametr', 'type' => 'text', 'avail' => 'akcja_1:ihome_data_set,ihome_data_write,send_command,http_open,variable_set'),
			'-2' => array('type' => '_flex_end'),

			'-3' => array('type' => '_flex_start', 'count' => 'four'),
				'akcja_2' => array('name' => 'Akcja 2', 'type' => 'select', 'options' => 'get_val:self:actions'),
				'komenda_cel_2' => array('name' => 'Nazwa pola', 'type' => 'select', 'options' => 'get_var:all_cmd_def_var', 'avail' => 'akcja_2:send_command'),			
				'akcja_parametr_out_2' => array('name' => 'nazwa pola', 'type' => 'select', 'options' => 'get_var:outs', 'avail' => 'akcja_2:out_d_1,out_d_0,out_d_toggle'),
				'urzadzenie_2' => array('name' => 'Nazwa urządzenia', 'type' => 'select', 'options' => 'get_var:devices', 'avail' => 'akcja_2:device_start,device_stop'),	
				'akcja_parametr_2' => array('name' => 'Parametr', 'type' => 'text', 'avail' => 'akcja_2:ihome_data_set,ihome_data_write,send_command,http_open'),
			'-4' => array('type' => '_flex_end'),

			'-5' => array('type' => '_flex_start', 'count' => 'four'),
				'akcja_3' => array('name' => 'Akcja 3', 'type' => 'select', 'options' => 'get_val:self:actions'),
				'komenda_cel_3' => array('name' => 'Nazwa pola', 'type' => 'select', 'options' => 'get_var:all_cmd_def_var', 'avail' => 'akcja_3:send_command'),			
				'akcja_parametr_out_3' => array('name' => 'nazwa pola', 'type' => 'select', 'options' => 'get_var:outs', 'avail' => 'akcja_3:out_d_1,out_d_0,out_d_toggle'),
				'urzadzenie_3' => array('name' => 'Nazwa urządzenia', 'type' => 'select', 'options' => 'get_var:devices', 'avail' => 'akcja_3:device_start,device_stop'),
				'akcja_parametr_3' => array('name' => 'Parametr', 'type' => 'text', 'avail' => 'akcja_3:ihome_data_set,ihome_data_write,send_command,http_open'),
			'-6' => array('type' => '_flex_end'),

			'-7' => array('type' => '_flex_start', 'count' => 'four'),
				'akcja_4' => array('name' => 'Akcja 4', 'type' => 'select', 'options' => 'get_val:self:actions'),
				'komenda_cel_4' => array('name' => 'Nazwa pola', 'type' => 'select', 'options' => 'get_var:all_cmd_def_var', 'avail' => 'akcja_4:send_command'),			
				'akcja_parametr_out_4' => array('name' => 'nazwa pola', 'type' => 'select', 'options' => 'get_var:outs', 'avail' => 'akcja_4:out_d_1,out_d_0,out_d_toggle'),
				'urzadzenie_4' => array('name' => 'Nazwa urządzenia', 'type' => 'select', 'options' => 'get_var:devices', 'avail' => 'akcja_4:device_start,device_stop'),
				'akcja_parametr_4' => array('name' => 'Parametr', 'type' => 'text', 'avail' => 'akcja_4:ihome_data_set,ihome_data_write,send_command,http_open'),
			'-8' => array('type' => '_flex_end'),

			'-9' => array('type' => '_flex_start', 'count' => 'four'),
				'akcja_5' => array('name' => 'Akcja 5', 'type' => 'select', 'options' => 'get_val:self:actions'),
				'komenda_cel_5' => array('name' => 'Nazwa pola', 'type' => 'select', 'options' => 'get_var:all_cmd_def_var', 'avail' => 'akcja_5:send_command'),			
				'akcja_parametr_out_5' => array('name' => 'nazwa pola', 'type' => 'select', 'options' => 'get_var:outs', 'avail' => 'akcja_5:out_d_1,out_d_0,out_d_toggle'),			
				'urzadzenie_5' => array('name' => 'Nazwa urządzenia', 'type' => 'select', 'options' => 'get_var:devices', 'avail' => 'akcja_5:device_start,device_stop'),	
				'akcja_parametr_5' => array('name' => 'Parametr', 'type' => 'text', 'avail' => 'akcja_5:ihome_data_set,ihome_data_write,send_command,http_open'),
			'-10' => array('type' => '_flex_end'),
		),

		'script' => array(
			'_na' => array('Nazwa skryptu'),
			'opis' => array('name' => 'Opis'),

			'akcja_nazwa' => array('name' => 'Nazwa pola'),
			'akcja_wartosc' => array('name' => 'Akcja'),
			'akcja_parametr' => array('name' => 'Dodatkowy parametr'),
		),

	);

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	
	//function __construct($f, $f2 = false)
	function __construct($f)
	{
		$this -> dataFile = $f;

		//if($f2)
			//$this -> pingScript = $f2;
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	/*
	public static function get_mod_desc($m)
	{
		$f = 'src/mod_'.$m.'_help_config.html';
		
		if(file_exists($f))
			return file_get_contents($f);
		else
			return false;
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function getElementsDesc($disp='')
	{
		$_d = self :: getDescMods();

		$tpls = array_keys(self :: $templates);

		$obj = array(
			'parameters' => array('Ogólne parametry', 'fa-cogs', 'Dane dostępowe, dane serwera MQTT, inne ogólne ustawienia'),
			'variables' => array('Zmienne', 'fa-usd', 'Zmiene używane w systemie'),			
			'gpio' => array('Piny kontrolera', 'fa-thumb-tack', 'Konfiguracja pinów GPIO'),
			'rflink' => array('RfLink', 'fa-flag', 'Rflink Gateway'),
			'rs485' => array('RS 485', 'fa-microchip', 'Magistrala RS485 z wykorzystaniem arduino'),
			'time' => array('Zdarzenia czasowe', 'fa-clock-o'),
			'tasks' => array('Zadania', 'fa-tasks', 'Grupa zadań wykonywana na zdarzenie'),
			'events' => array('Zdarzenia', 'fa-eye-slash'),
			'i2c' => array('I2C', 'fa-microchip'),
			'ports' => array('Porty', 'fa-usb', 'Obsługa danych z portów USB'),
			'devices' => array('Urządzenia zewnętrzne', 'fa-desktop', ''),
			'zigbee' => array('Zigbee', 'fa-object-group'),
			'script' => array('Skrypty', 'fa-usb', ''),
		);

		$ret = array();
		foreach($tpls as $v)
		{
			//$ret[$v] = array('name' => arr :: getm($obj, array($v, 0), $v), 'desc' => arr :: getm($obj, array($v, 2), '---'), 'ico' => arr :: getm($obj, array($v, 1), '---'));
			$ret[$v] = array('name' => arr :: getm($obj, array($v, 0), $v), 'desc' => arr :: get($_d, $v, '---'), 'ico' => arr :: getm($obj, array($v, 1), '---'));
		}


		if($disp == 'start')
		{
			$ks = array('gpio', 'variables', 'ports', 'rs485', 'i2c', 'rflink', 'devices', 'zigbee', 'events', 'time', 'tasks');
			$ret = arr :: get_by_keys($ret, $ks);
			$ret = arr :: sort_by_keys($ret, $ks);
		}

		return $ret;
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function getDescMods($n = false)
	{
		include('src/description_mods.php');
		return $n? arr :: get($DESCRIPTION_MODS, $n, '') : $DESCRIPTION_MODS ;
	}
*/
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
/*
	public static function requireToVar($file, $variables = array()){
		extract($variables);
		ob_start();
		//if(file_exists($file))
			require($file);
		return ob_get_clean();
	}
*/
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function isValidElement($n)
	{
		$tpls = array_keys(self :: $templates);
		return in_array($n, $tpls);
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function getUsedGpioHtml($configObj)
	{
		$ret = array();

		foreach($configObj as $k => $v)
		{
			if($k == 'gpio')
			{
				foreach(self :: $gpioList as $gp_g => $gp_n)
				{
					$ret[$gp_g] = $gp_n;
					foreach($v as $v1)
					{				
						if(isset($v1['numer']) && $v1['numer'] == $gp_g)
						{
							$ret[$gp_g] .= ' / ' . $v1['nazwa'];
						}
					}
				}
			}
		}

		$s = '<div class="tbl">';
		foreach($ret as $k => $v)
			$s .= '<div class="tr"><div class="td r f-min">'.$k.'</div><div class="td f-min" style="color:#999;">|&nbsp;&nbsp;</div><div class="td f-min">'.$v.'</div></div>';	
		$s .= '</div>';

		return $s;
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function getSystemElements($configObj = array())
	{
		$all_fields = array();
		$variables = array();
		$variables_time = array();
		$outs = array();
		$ports_def = array();
		$rs485_def = array();
		$i2c_def = array();	
		$all_cmd_def_var = array(); //def zmienne
		$gpio_list = array();
		$tasks_list = array();
		$devices = array();

		foreach(self :: $gpioList as $k => $v)
			$gpio_list[$k] = $k . ($v>''? ' ['.$v.']' : '') ;

		foreach(self :: $spec_variables as $k => $e)
		{
			$nk = '_vs_'.$k;
			$all_fields[$nk] = 'zmienna-spec: ' . ($e['opis'] > ''? $e['opis'] : $e['nazwa']);
			$variables[$nk] = 'var spec: ' . ($e['opis'] > ''? $e['opis'] : $e['nazwa']);
			$variables_time[$nk] = 'var spec: ' . ($e['opis'] > ''? $e['opis'] : $e['nazwa']);
		}
		
		foreach(self :: $sys_err_variables as $k => $e)
		{
			$nk = '_err_'.$k;
			$all_fields[$nk] = 'zmienna-err: ' . ($e['opis'] > ''? $e['opis'] : $e['nazwa']);
			$variables[$nk] = 'var err: ' . ($e['opis'] > ''? $e['opis'] : $e['nazwa']);
			$variables_time[$nk] = 'var err: ' . ($e['opis'] > ''? $e['opis'] : $e['nazwa']);
		}
		
		foreach($configObj as $k => $v)
		{
			if($k == 'variables')
			{
				foreach($v as $v1)
				{
					$all_fields[$v1['nazwa']] = 'zmienna: ' . ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);
					$variables[$v1['nazwa']] = 'var: ' . ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);
					$all_cmd_def_var[$v1['nazwa']] = 'var: ' . ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);

					if($v1['typ'] == 'time')
						$variables_time[$v1['nazwa']] = 'var: ' . ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);
				}
			}
			else if($k == 'gpio')
			{
				foreach($v as $v1)
				{
					$all_fields[$v1['nazwa']] = 'gpio: ' . ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);
			
					if($v1['typ'] == 'out_d_0')
						$outs[$v1['nazwa']] = ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);

					if(isset($v1['numer']))
					{
						$nn = (integer)$v1['numer'];
						if($nn > 0)
							$gpio_list[$nn] = $gpio_list[$nn] . ' - ' . $v1['nazwa'];
					}
				}
			}
			else if($k == 'ports')
			{
				foreach($v as $v1)
				{
					if($v1['typ'] == 'definicja')
					{
						$all_fields[$v1['nazwa']] = 'port: ' . ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);
						$all_cmd_def_var[$v1['nazwa']] = 'port: ' . ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);
						$ports_def[$v1['nazwa']] = 'port: ' . ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);
					}
					else
					{
						$dd = substr(arr :: get($all_fields, $v1['definicja'], ''), 0, 40);
						$all_fields[$v1['nazwa']] = $dd . '/' . ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);
					}
				}
			}
			else if($k == 'rs485')
			{
				foreach($v as $v1)
				{
					if($v1['typ'] == 'definicja')
					{
						$rs485_def[$v1['nazwa']] = ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);
						$all_fields[$v1['nazwa']] = 'rs485: ' . ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);	
						$all_cmd_def_var[$v1['nazwa']] = 'rs485: ' . ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);	
					}
					else if($v1['typ'] == 'element')
					{
						$dd = substr(arr :: get($all_fields, $v1['definicja'], ''), 0, 40);
						$all_fields[$v1['nazwa']] = $dd . '/' . ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);	
						$all_cmd_def_var[$v1['nazwa']] = $dd . '/' . ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);	
					}
				}
			}			
			else if($k == 'i2c')
			{
				foreach($v as $v1)
				{
					if($v1['typ'] == 'definicja')
					{
						$i2c_def[$v1['nazwa']] = ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);
						$all_fields[$v1['nazwa']] = 'i2c: ' . ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);	
						$all_cmd_def_var[$v1['nazwa']] = 'i2c: ' . ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);
					}
					else
					{
						//$dd = substr(arr :: get($all_fields, $v1['definicja'], ''), 0, 40);						
						$dd = substr(arr :: get($all_fields, arr :: get($v1, 'definicja', ''), ''), 0, 40);
						$all_fields[$v1['nazwa']] = $dd . '/' . ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);	
					}
				}
			}
			else if($k == 'devices')
			{
				foreach($v as $v1)
				{	
					$devices[$v1['nazwa']] = ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);
				}				
			}			
			else if($k == 'tasks')
			{
				foreach($v as $v1)
				{	
					$tasks_list[$v1['nazwa']] = ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);
				}
			}
			else if($k == 'zigbee')	
			{
				foreach($v as $v1)
				{
					if($v1['typ'] == 'pk')
						$all_cmd_def_var[$v1['nazwa']] = 'zigbee: ' . ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);
					//if($v1['typ'] == 'pk')
					{						
						$devices[$v1['nazwa']] = 'zigbee: ' . ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);
						$all_fields[$v1['nazwa']] = 'zigbee' . '/' . ($v1['opis'] > ''? $v1['opis'] : $v1['nazwa']);	
					}
				}
			}
		}
/*
		$all_fields = array();
		$variables = array();
		$variables_time = array();
		$outs = array();
		$ports_def = array();
		$rs485_def = array();
		$i2c_def = array();	
		$all_cmd_def_var = array();
		$gpio_list = array();
		$tasks_list = array();
		$devices = array();
*/		

		return compact('all_fields', 'variables', 'variables_time', 'outs', 'ports_def', 'rs485_def', 'i2c_def', 'all_cmd_def_var', 'gpio_list', 'tasks_list', 'devices');
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function getTemplates($configObj = array())
	{
		$sxs = self :: getSystemElements($configObj);
		extract($sxs);

		$tpl = self :: $templates;

		foreach($tpl as $k1 => $v1)
		{
			foreach($v1 as $k2 => $v2)
			{
				if(isset($v2['options']))
				{
					$opt = $v2['options'];
					if(is_string($opt))
					{
						$_options = [];
						if(substr($opt, 0, 11) == 'get_global:')
						{
							$_gb_var = substr($opt, 11);
							$_options = arr :: get($GLOBALS, $_gb_var, array());
						}
						else if(substr($opt, 0, 8) == 'get_val:' && count($ex = explode(':', $opt)) == 3)
						{
							if($ex[1] == 'self')
								$_options = self :: ${$ex[2]};
						}
						else if(substr($opt, 0, 8) == 'get_var:' && count($ex = explode(':', $opt)) == 2)
						{
							$_options = isset(${$ex[1]})? ${$ex[1]} : ['-blad-zmiennej-'] ;	
						}
						
						$tpl[$k1][$k2]['options'] = $_options;
					}

				}
			}
		}

		return $tpl;
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public function get($n = false)
	{
		if($this -> dataFile && (file_exists($this -> dataFile)))
		{
			$str = file_get_contents($this -> dataFile);
			$obj = json_decode($str, true);

			if($n != false)
				return arr :: get($obj, $n);
			else
				return $obj;
		}
		else
			return array();
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public function save($a)
	{
		$ret = array();

		$ret['parameters'] = arr :: get($a, 'parameters', array());		

		$hashObj = array();
		$zmienne = array('events' => '', 'variables' => '', 'gpio' => '', 'time' => '', 'ports' => '', 'rs485' => '', 'i2c' => '', 'rflink' => '', 'devices' => '', 'tasks' => '');

		foreach($zmienne as $grpName => $ge)
		{
			$ret[$grpName] = array();
			$elem = arr :: get($a, $grpName, array());
			foreach($elem as $v)
			{
				$nn = $v['nazwa'];
				if($nn)
				{
					$ret[$grpName][] = $v;
					$hashObj[] = $nn;
				}
			}
		}
		
		
		$hashStr = arr :: get($a, '_hashStr', '@');
		if($hashStr != '@')
		{
			sort($hashObj);
			if($hashStr != md5(join('|', $hashObj)))
				return false;
		}
		
		$ret['heating'] = $this -> get('heating');

		file_put_contents($this -> dataFile, json_encode($ret));

		return true;
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public function save_element($name, $obj2save)
	{
		if($name == 'parameters')		
		{
			$obj = arr :: get($obj2save, 'parameters', array());
			
			if(count($obj))
				$this -> saveElement2file('parameters', $obj);
		}
		else if(isset($obj2save[$name]))	
		{
			$hashStr = arr :: get($obj2save, '_hashStr', '@');
			$obj2save = $obj2save[$name];

			$ret = array();
			
			foreach($obj2save as $v)
			{
				$nn = $v['nazwa'];
				if($nn)
				{
					$ret[] = $v;
					$hashObj[] = $nn;
				}
			}

			if($hashStr != '@')
			{
				sort($hashObj);
				
				if($hashStr != md5(join('|', $hashObj)))
					return false;
			}

			return $this -> saveElement2file($name, $ret);
		}

		return false;
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public function save_simple_element($name, $obj2save)
	{
		if(file_exists($this -> dataFile))
		{
			$str = file_get_contents($this -> dataFile);
			$obj = json_decode($str, true);

			if(is_array($obj))
			{
				if(isset($obj2save['_hashStr']))
					unset($obj2save['_hashStr']);

				$obj[$name] = $obj2save;
				file_put_contents($this -> dataFile, json_encode($obj));
			}
		}

		//echo '<pre style="font-family:verdana;font-size:10px;">'.print_r($obj, true).'</pre>';
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	private function saveElement2file($name, $obj2save)
	{
		if(file_exists($this -> dataFile))
		{
			$str = file_get_contents($this -> dataFile);
			$obj = json_decode($str, true);

			if(is_array($obj))
			{
				$obj[$name] = $obj2save;
				file_put_contents($this -> dataFile, json_encode($obj));

				return true;
			}
		}
		
		return false;
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public function ch_pos($type, $nr, $action)
	{
		if(file_exists($this -> dataFile))
		{
			$str = file_get_contents($this -> dataFile);
			$obj = json_decode($str, true);

			if(is_array($obj))
			{				
				$d = arr :: get($obj, $type, array());
				$count = count($d);
				$nr = (integer)$nr;
				
				if($count >= 2 && $nr < $count)
				{
					$prev_nr = $nr > 0? $nr - 1 : $count - 1;
					$next_nr = $nr < $count - 1? $nr + 1 : 0;					
					
					$prev_d = $d[$prev_nr];
					$next_d = $d[$next_nr];
					$act_d = $d[$nr];					
					
					if($action == 'up')
					{
						if($nr > 0)
						{
							$d[$prev_nr] = $act_d;
							$d[$nr] = $prev_d;
						}
						else
						{
							$x = array_shift($d);
							$d[] = $x;
						}
					}
					else if($action == 'down')
					{
						if($nr < $count-1)
						{
							$d[$next_nr] = $act_d;
							$d[$nr] = $next_d;
						}
						else
						{
							$x = array_pop($d);
							array_unshift($d, $x);
						}
					}

					if(count($d) == $count)
					{
						$obj[$type] = $d;
						$str = json_encode($obj);
						file_put_contents($this -> dataFile, $str);
					}
				}
			}
		}
	}
	public function ch_active($type, $name)
	{
		if(file_exists($this -> dataFile))
		{
			$str = file_get_contents($this -> dataFile);
			$obj = json_decode($str, true);

			if(is_array($obj))
			{				
				$d = arr :: get($obj, $type, array());
				
				if(count($d) > 0)
				{
					foreach($d as $k => $v)
					{
						if($v['nazwa'] == $name)
						{
							$d[$k]['aktywny'] = (isset($v['aktywny']) && $v['aktywny'] == 1)? 0 : 1;
						}
					}
					$obj[$type] = $d;
					$str = json_encode($obj);
					file_put_contents($this -> dataFile, $str);
				}				
			}
		}
	}
}

?>