<?php

if(!defined('ROOT_DIR'))
	define('ROOT_DIR', dirname(__FILE__) . '/');

include_once(ROOT_DIR . '_top.php');

set_time_limit(240);

$RAM_DISK_PATH = arr :: getm($CONFIG, 'parameters.main.ram_disk_path', '');
$RAM_DISK_PATH = $RAM_DISK_PATH > '' ? $RAM_DISK_PATH  : ROOT_DIR . 'data/';


// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

header('HTTP/1.1 200 OK');
header('Content-Type: text/html; charset=utf-8');

$n = http :: _get('nazwa', '');

$scripts = arr :: get($CONFIG, 'script', array());
$scripts = arr :: ch_key($scripts, 'nazwa');

$e = arr :: get($scripts, $n);

if($e && arr :: get($e, 'aktywny') == 1 && checkIpOk(arr :: getm($CONFIG, 'parameters.main.broadcast_ip', ''), arr :: get($_SERVER, 'REMOTE_ADDR', '')))
{
	$name = $e['akcja_nazwa'];
	$action = $e['akcja_wartosc'];
	$param = $e['akcja_parametr'];

	if($action == '' && $param == '')
		$action = -1;
	
	$is2do = check2dodo($n, $RAM_DISK_PATH);
	
	if($is2do === true)
	{
		$ret = pt :: command('read_write', $name, $action, $param);
		pt :: command('pt', 'log_user_script', $n);
		$retArr = json_decode($ret, true);
		exit(arr :: get($retArr, $name, '---err---'));
	}
	else
		exit('locked: ' . $is2do);
}

exit('0');

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

function checkIpOk($ip, $from)
{
	if($from == '::1')
		return true;
	else
	{
		$a = explode('.', $ip . '...');
		$b = explode('.', $from . '...');

		return $a[0] == $b[0] && $a[1] == $b[1] || $a[3] == $b[3];
	}
	return false;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

function check2dodo($n, $path)
{
	$f = $path . 'script_php_check_2do.tmp_json';
	$czas = 4;

	if(file_exists($f))
	{		
		$obj = json_decode(file_get_contents($f), true);
		$tm = arr :: get($obj, $n, 0);

		if($tm > time() - $czas)
			return abs(time() - $czas - $tm);
		else
		{
			$obj[$n] = time();
			$ret = true;
		}
	}
	else
	{
		$ret = true;
		$obj = array($n => time());
	}
	
	file_put_contents($f, json_encode($obj));
	return $ret;	
}

?>