import os
import sys
import time
from datetime import datetime
import platform
ROOT_DIR = os.path.abspath(os.path.join(os.path.dirname( __file__ ), '..'))+"/"
sys.path.append(ROOT_DIR + 'pt/')
PLATFORM = 'win' if platform.system() == 'Windows' else 'rpi'
from lib.rxtx_class import *
from lib.mk_class import dataX
from lib.mqtt_class import mqttBroker
from _config_top import *
SQL = msqlLite(SQL_PATH)
SQL_REPLY = msqlLite(SQL_PATH, 'reply')
RFLINK = False
RF_ACTIVE = False
DATA_VAR = {}
DATA_MEM = {}
class rflink:
 def __init__ (self, port):#, dataFile
  self.obj = {}
  self.rxtx = rxtx(port, 57600, 0.1)
  self.rxtx.setReadEvt(self.rfLinkReadEvent)
  self.rxtx.start()
 def stop(self):
  self.rxtx.stop()
 def resetDefinitions(self):
  self.obj = {}
 def addDefinition(self, name, protocol, idd, nr, commands, opt={}):
  self.obj[name] = {'name' : name, 'protocol' : protocol.strip(), 'id' : idd.strip(), 'nr' : nr.strip(), 'opt':opt}
  self.obj[name]['commands'] = commands
 def set(self, name, cmd):
  global DATA_VAR
  if name in self.obj:
   if cmd in self.obj[name]['commands']:
    _pr = self.obj[name]['protocol']
    _id = self.obj[name]['id']
    _nr = self.obj[name]['nr']
    DATA_VAR[name] = cmd
    DATA_MEM[fn.date_full(True)] = '>&nbsp;' + _pr+";"+_id+";"+_nr+";"+cmd
    self.rxtx.write("10;"+_pr+";"+_id+";"+_nr+";"+cmd+";\r\n")
 def rfLinkReadEvent(self, txt):	
  global DATA_VAR
  global DATA_MEM
  if len(txt) > 5:
   DATA_MEM[fn.date_full(True)] = '<&nbsp;' + fn.simple_chars(txt)
  ob = self.parseAnswer(txt)
  if ob:
   for a in self.obj:
    x = self.obj[a]
    if self.getOb(x, ob):
     v = ob['val']
     if len(x['opt']['wyr']['tak']) > 0 or len(x['opt']['wyr']['nie']) > 0:
      _v = value.is_10(txt, x['opt']['wyr']['tak'], x['opt']['wyr']['nie'], -123456789)
      if _v != -123456789:
       v = _v					
     elif len(x['opt']['nval']['reg'])>0 and len(txt)>=2:
      if len(x['opt']['nval']['proc_min'])>0 and len(x['opt']['nval']['proc_max'])>0:
       _v = value.expression(txt, x['opt']['nval']['reg'], -123456789, [x['opt']['nval']['proc_min'], x['opt']['nval']['proc_max']])
      else:
       _v = value.expression(txt, x['opt']['nval']['reg'], -123456789)
      if _v != -123456789:
       v = _v
     DATA_VAR[x['name']] = v
 @staticmethod
 def parseAnswer(txt):
  o1 = txt.split(';')		
  if len(o1) >= 6:
   ret = {'protocol' : o1[2], 'id':'', 'nr':'', 'val':''}
   for i in range(len(o1)):
    o2 = o1[i].split('=')
    if len(o2) >= 2:
     if o2[0] == 'ID':
      ret['id'] = o2[1]
     elif o2[0] == 'SWITCH':
      ret['nr'] = o2[1]	
     elif o2[0] == 'CMD':
      ret['val'] = o2[1]	
   return ret
  else:
   return False;
 @staticmethod
 def getOb(x, ob):
  _a = (len(x['protocol']) > 0 and x['protocol'] == ob['protocol']) or len(x['protocol']) == 0
  if len(x['id']) > 0:
   if x['id'].find(';') != -1:
    _em = x['id'].split(';')
    _b = False
    for _emx in _em:					
     if _emx == ob['id']:
      _b = True
   else:
    _b = True if x['id'] == ob['id'] else False
  else:
   _b = True
  _c = (len(x['nr']) > 0 and x['nr'] == ob['nr']) or len(x['nr']) == 0
  return True if _a and _b and _c else False
def rf_getStartData():
 global FILE_CONFIG, RFLINK, RF_ACTIVE
 _rf_start = json_file_get_var(FILE_CONFIG, 'parameters.rflink', {})	
 RFLINK_PORT = var_get(_rf_start, 'port', '')
 RF_ACTIVE = var_get_int(_rf_start, 'aktywny') == 1
 if len(RFLINK_PORT) > 0:
  if RFLINK == False:
   RFLINK = rflink(RFLINK_PORT)
  RFLINK.resetDefinitions()
  CONFIG_OBJ = json_file_get(FILE_CONFIG)
  for a in CONFIG_OBJ['rflink']:
   if var_get_int(a, 'aktywny') == 1:
    RFLINK.addDefinition(a['nazwa'], a['protokol'], a['id'], a['numer'], a['komendy'].split(';'), {'wyr':a['wyrazenie'], 'nval':a['number_val']})#
 else:
  if RFLINK:
   RFLINK.stop()
   RFLINK = False
def check2do():
 global RFLINK, SQL
 d = SQL.getValues('rflink_cmd')
 if len(d) > 0:
  _k, _v = d.popitem()
  if RFLINK:
   RFLINK.set(_k, _v)
  SQL.delVal('rflink_cmd', _k)
'''
if len(RFLINK_PORT) > 0:
 RFLINK = rflink(RFLINK_PORT, FILE_RFLINK_DATA)
 rf_getStartData()
else:
 RFLINK = False
'''
rf_getStartData()
if PLATFORM == 'win':
 print('rflink start')
x = 1;
try:
 while 1: 	
  x = x + 1
  if x % 10 == 0:
   if RFLINK and RF_ACTIVE:
    check2do()
    SQL.setValues('rflink', DATA_VAR)
    DATA_MEM = SQL_REPLY.setSortLimit('rflink', DATA_MEM, 20)
  if x == 600:
   x = 1
   sys_workingModules.set('rflink')
   rf_getStartData()
  time.sleep(0.1)
except KeyboardInterrupt:
 if RFLINK:
  RFLINK.stop()
 print('Koniec')
