import sys
import os
import json
import time
import copy
from subprocess import call
import datetime
import threading
ROOT_DIR = os.path.abspath(os.path.join(os.path.dirname( __file__ ), '..'))+"/"
sys.path.append(ROOT_DIR + 'pt/')
from lib.mk_class import *
from lib.outin_class import *
from lib.disp_ssd1306_class import disp_ssd1306
from read_write import sendCommand2Element, readAllElements
from _config_top import *
if PLATFORM == 'rpi':
 import RPi.GPIO as GPIO
 from w1thermsensor import W1ThermSensor
 GPIO.setwarnings(False)
 GPIO.setmode(GPIO.BCM)
SQL = msqlLite(SQL_PATH)
file_create_if_no(FILE_SENSORS)
file_create_if_no(FILE_PWM_DATA)
evtTime = evTime()
bkEvent = blockEvent()
if len(OLED_PARAMS['addr']) > 0:
 oledDisplay = disp_ssd1306(eval(OLED_PARAMS['addr']), True)
 oledDisplay.setOptions(OLED_PARAMS['options'])	
else:
 oledDisplay = False
def mk_getStartData(is_start = False):
 global FILE_CONFIG
 global FILE_REPOSITORY
 global CONFIG_OBJ
 CONFIG_OBJ = json_file_get(FILE_CONFIG)	
 repo_obj = json_file_get(FILE_REPOSITORY)
 for a in CONFIG_OBJ['time']:
  if a['typ'] == 'every' and len(a['parametr']) > 0:
   if is_start:
    evtTime.addEvery(a['nazwa'], a['parametr'])
   else:
    evtTime.update(a['nazwa'], a['parametr'])
  elif a['typ'] == 'time' and len(a['parametr']) > 0:
   if is_start:
    evtTime.addTime(a['nazwa'], a['parametr'])
   else:
    evtTime.update(a['nazwa'], a['parametr'])
  elif a['typ'] == 'time' and len(a['parametr_var']) > 0:
   var_time = var_get(repo_obj, ['variables', a['parametr_var']], '')
   if len(var_time) == 5:
    if is_start:
     evtTime.addTime(a['nazwa'], var_time)
    else:
     evtTime.update(a['nazwa'], var_time)
mk_getStartData(True)
pwmObj = pwmControl()
sensnObj = sensors(FILE_SENSORS)
for a in CONFIG_OBJ['gpio']:
 if len(a["nazwa"]) > 0:
  if a['typ'] == 'ds18b20':
   o = W1ThermSensor(W1ThermSensor.THERM_SENSOR_DS18B20, a["mac"]) if PLATFORM == 'rpi' else {}
   sensnObj.addSensor(a["nazwa"], o)
  elif a['typ'] == 'pwm':
   nr = int(a['numer'])
   freq = int(a['czestotliwosc']) if len(a['czestotliwosc']) > 0 else 0
   if PLATFORM == 'rpi':
    GPIO.setup(nr, GPIO.OUT)
   o = GPIO.PWM(nr, freq) if PLATFORM == 'rpi' else {}
   pwmObj.add(a["nazwa"], o);
GPIX = gpioOutIn(CONFIG_OBJ['gpio'], DIR_QUICK_MEM if PLATFORM == 'win' else '')
def out_get(n):
 global GPIX
 return GPIX.out_get(n)
def out_set_toggle(n):
 global GPIX
 return GPIX.out_set_toggle(n)
def out_set(n, v):
 global GPIX
 return GPIX.out_set(n, v)
GLOBAL_WARTOSCI_MINT = {}
def get_wartosci_mint(is_check = False):	
 global GLOBAL_WARTOSCI_MINT, sys_var_spec, sys_err
 if is_check:
  zwrot = {}	
  zwrot = obj_merge(zwrot, sys_var_spec.get_all(), '_vs_')
  zwrot = obj_merge(zwrot, sys_err.get_all(), '_err_')
  GLOBAL_WARTOSCI_MINT = copy.copy(zwrot)
 else:
  return GLOBAL_WARTOSCI_MINT
 return zwrot
def get_val_len_ok(obj):
 ret = {}
 for a in obj:
  if len(obj[a]) > 0:
   ret[a] = obj[a]
 return ret
DB_SQL_VALUES = {}
def mk_set_sql_values():
 global DB_SQL_VALUES
 wt = {}
 i2c_d = get_val_len_ok(SQL.getValues('i2c'))
 wt = obj_merge(wt, i2c_d)
 rs485_d = get_val_len_ok(SQL.getValues('rs485'))
 wt = obj_merge(wt, rs485_d)
 rflink_d = get_val_len_ok(SQL.getValues('rflink'))
 wt = obj_merge(wt, rflink_d)
 zigbee_d = get_val_len_ok(SQL.getValues('zigbee'))
 wt = obj_merge(wt, zigbee_d)	
 devices_d = get_val_len_ok(SQL.getValues('devices'))
 wt = obj_merge(wt, devices_d)
 wt = obj_merge(wt, SQL.getValues('vars_exp'))
 DB_SQL_VALUES = wt
def get_wartosci(is_check = False):
 global CONFIG_OBJ
 global DB_SQL_VALUES
 global FILE_REPOSITORY
 global FILE_VARIABLES_SPECIAL
 global FILE_PORTS_DATA
 wt = {}
 for a in CONFIG_OBJ['gpio']:
  if len(a['nazwa']) > 0:
   n = a['nazwa']		
   if a['typ'] == 'ds18b20':
    wt[n] = sensnObj.get(a['nazwa'])
   elif (a['typ'] == 'out_d_0' or a['typ'] == 'input_d_1'):
    wt[n] = out_get(a['nazwa'])
 variables_set = json_file_get_var(FILE_REPOSITORY, 'variables', {})
 for a in CONFIG_OBJ['variables']:
  if len(a['nazwa']) > 0:
   wt[a['nazwa']] = var_get(variables_set, a['nazwa'])
 pd = json_file_get(FILE_PORTS_DATA)
 for a in CONFIG_OBJ['ports']:
  n = a['nazwa']
  if len(n) > 0:
   v = var_get(pd, n, -12345)
   if v != -12345:
    wt[n] = v	
 wt = obj_merge(wt, DB_SQL_VALUES)
 return obj_merge(wt, get_wartosci_mint(is_check))
def backup_power_data(action):
 global ROOT_DIR
 global SQL
 global GPIX
 f = ROOT_DIR + 'data/backup_quick_data.json'
 if action == 1:
  obj = {
   'rflink' : get_val_len_ok(SQL.getValues('rflink')),
   'gpio' : GPIX.backup_get()
  }
  if len(obj) > 0:
   json_file_save(f, obj)
 else:
  if os.path.isfile(f) == True:
   obj = json_file_get(f)
   if len(obj) > 0:				
    obj_rf = var_get(obj, 'rflink', {})
    obj_gpio = var_get(obj, 'gpio', {})				
    SQL.setValues('rflink', obj_rf)
    GPIX.backup_set(obj_gpio)				
   file_del(f)
def wykonaj_liste_zadan(n, values):
 global CONFIG_OBJ
 tasks = var_get(CONFIG_OBJ, 'tasks', {})
 obj = var_get_by(tasks, 'nazwa', n, False)
 if obj != False and var_get_int(obj, 'aktywny') == 1:
  for x in range(1, 6): #od 1 do 5
   ac = var_get(obj, 'akcja_'+str(x), '')
   kc = var_get(obj, 'komenda_cel_'+str(x), '')
   ap = var_get(obj, 'akcja_parametr_'+str(x), '')
   ao = var_get(obj, 'akcja_parametr_out_'+str(x), '')
   urz = var_get(obj, 'urzadzenie_'+str(x), '')
   if len(ac) > 0:
    zadanie_wykonaj({'nazwa' : 'ac'+str(x), 'akcja' : ac, 'komenda_cel' : kc, 'akcja_parametr' : ap, 'akcja_parametr_out' : ao, 'urzadzenie':urz}, values)
def zadanie_wykonaj(z, values):
 global SQL
 global FILE_HTTP_2SEND
 global IHOME_IDENT
 global IHOME_KEY	
 if z['akcja'] == 'shutdown':
  backup_power_data(1)
  mk_python('power', 'shutdown')
  time.sleep(10)
 elif z['akcja'] == 'restart' or z['akcja'] == 'reboot':
  backup_power_data(1)
  time.sleep(1)
  mk_python('power', 'reboot')
  time.sleep(10)
 elif z['akcja'] == 'out_d_1':
  out_set(z['akcja_parametr_out'], 1)
  time.sleep(0.1)
 elif z['akcja'] == 'out_d_0':
  out_set(z['akcja_parametr_out'], 0)
  time.sleep(0.1)
 elif z['akcja'] == 'out_d_toggle':
  out_set_toggle(z['akcja_parametr_out'])
  time.sleep(0.1)
 elif z['akcja'] == 'ihome_data_set' and len(IHOME_IDENT) > 0 and len(IHOME_KEY) > 0:
  param = mk_replaceString2Values(z['akcja_parametr'], values)
  SQL.setVal('http_2send', z["nazwa"], 'https://ihome.net2me.pl/set-data/'+IHOME_IDENT+'/'+IHOME_KEY+'/'+param)
 elif z['akcja'] == 'ihome_data_write' and len(IHOME_IDENT) > 0 and len(IHOME_KEY) > 0:
  param = mk_replaceString2Values(z['akcja_parametr'], values)
  SQL.setVal('http_2send', z["nazwa"], 'https://ihome.net2me.pl/write-data/'+IHOME_IDENT+'/'+IHOME_KEY+'/'+param)
 elif z['akcja'] == 'send_command' and len(z['komenda_cel']) > 0:
  _ap = z['akcja_parametr']
  if _ap.find('$') != -1:
   _ap = mk_replaceString2Values(_ap, values)
  if _ap.find(',') != -1:
   _z1, _z2 = _ap.split(',')
   sendCommand2Element(z['komenda_cel'], _z1, _z2)
  else:
   sendCommand2Element(z['komenda_cel'], _ap)
 elif z['akcja'] == 'send_command' and len(z['komenda_cel']) == 0 and len(z['akcja_parametr']) > 0:
  _ap = z['akcja_parametr']
  if _ap.find('=') != -1:
   if _ap.find('$') != -1:
    _ap = mk_replaceString2Values(_ap, values)
   _z1, _z2 = _ap.split('=')
   sendCommand2Element(_z1, _z2)
 elif z['akcja'] == 'http_open' and len(z['akcja_parametr']) > 0:
  mk_zadanie_wykonaj_http_get(z['akcja_parametr'])
 elif z['akcja'] == 'device_start' and len(z['urzadzenie']) > 0:
  sendCommand2Element(z['urzadzenie'], '1')
 elif z['akcja'] == 'device_stop' and len(z['urzadzenie']) > 0:
  sendCommand2Element(z['urzadzenie'], '0')	
 elif z['akcja'] == 'run_task' and len(z['zadanie']) > 0:
  wykonaj_liste_zadan(z['zadanie'], values)
 elif z['akcja'] == 'save2sysnote' and len(z['akcja_parametr']) > 0:
  _ap = mk_replaceString2Values(z['akcja_parametr'], values)
  sys_note.write(z['nazwa'], _ap)
def zadanie_wykonaj_test2do(values):
 global CONFIG_OBJ
 global SQL
 d = SQL.getValues('events_2do')
 if len(d) > 0:
  _k, _v = d.popitem()
  _n = _k[0:5]
  add2loguser('events_2do', _n + '|' +_v, values, '#2061bd')#blue
  if _n == 'event':
   for a in CONFIG_OBJ['events']:
    if a['nazwa'] == _v:
     zadanie_wykonaj(a, values)
  elif _n == 'times':
   for a in CONFIG_OBJ['time']:
    if a['nazwa'] == _v:
     zadanie_wykonaj(a, values)
  elif _n == 'tasks':
   for a in CONFIG_OBJ['tasks']:
    if a['nazwa'] == _v:
     wykonaj_liste_zadan(_v, values)
  elif _n == 'power':
   backup_power_data(1)
   mk_python('power', _v)#zapis w read_write
  SQL.delVal('events_2do', _k)
def mk_zadanie_wykonaj_http_getTHD(url):
 http_get(url, 5)
def mk_zadanie_wykonaj_http_get(url):
 thread = threading.Thread(target=mk_zadanie_wykonaj_http_getTHD, args=(url, ))
 thread.start()
'''
def update_variables_by_other_vars(values):
 global CONFIG_OBJ
 global FILE_REPOSITORY
 global VARIABLES_SET
 vars2check = arr.get_by_val(CONFIG_OBJ['variables'], 'typ', 'conditional')
 saveVars = {}
 for a in vars2check:
  setVa = 1 if a['wyrazenie'] == 'n1' else 0
  setVb = 0 if a['wyrazenie'] == 'n1' else 1
  if check_str_conditions_on_vars(a['if_zawiera'], values, var_get_int(a, 'warunek_lub') == 1):
   v = setVa + 0
  else:
   v = setVb + 0
  saveVars[a['nazwa']] = v
 is_must_save = False
 for a in saveVars:
  if str(saveVars[a]) != str(var_get(VARIABLES_SET, a, '')):
   is_must_save = True		
   VARIABLES_SET[a] = saveVars[a]
 if is_must_save:
  json_file_add_var(FILE_REPOSITORY, 'variables', VARIABLES_SET)
 vars_exp = arr.get_by_val(CONFIG_OBJ['variables'], 'typ', 'exp')
 is_must_save = False
 current_vars = SQL.getValues('vars_exp')
 for a in vars_exp:
  _exp = a['value_exp'] 
  _reg = _exp['reg']
  _err = False
  if _reg.find('$') != -1:
   _reg = mk_replaceString2Values(_reg, values)	
  try:
   v = eval(_reg)
  except Exception:
   v = 'err'
   _err = True
  if _err == False and len(_exp['proc_min']) > 0 and len(_exp['proc_max']):
   v = value.procent(v, _exp['proc_min'], _exp['proc_max'])
  if str(v) != str(var_get(current_vars, a['nazwa'], '')):	
   is_must_save = True
   current_vars[a['nazwa']] = v
 if is_must_save == True:
  SQL.setValues('vars_exp', current_vars, {'clear':1})
'''
def update_variables_by_other_vars(values):
 global CONFIG_OBJ, SQL
 vars_exp = arr.get_by_val(CONFIG_OBJ['variables'], 'typ', 'exp')
 is_must_save = False
 current_vars = SQL.getValues('vars_exp')
 for a in vars_exp:
  _reg = a['reg']
  _nv = a['number_val'] 		
  _err = False
  if _reg.find('$') != -1:
   _reg = mk_replaceString2Values(_reg, values)	
  if _reg.find('|') != -1:
   __v, __fnt = _reg.split('|')			
   if __fnt == 'lifepo4_proc':
    v = lifepo4_proc(__v)
   else:
    v = -1
    _err = True			
  else:
   try:
    v = eval(_reg)
   except Exception:
    v = -1
    _err = True
  if _err == False and len(_nv['proc_min']) > 0 and len(_nv['proc_max']):
   v = value.procent(v, _nv['proc_min'], _nv['proc_max'])
  if str(v) != str(var_get(current_vars, a['nazwa'], '')):	
   is_must_save = True
   current_vars[a['nazwa']] = v
 if is_must_save == True:
  SQL.setValues('vars_exp', current_vars, {'clear':1})
if PLATFORM == 'win':
 add2log(False)
 print('mk start')
'''
wartosci = get_wartosci()
zad = var_get_by(CONFIG_OBJ['events'], 'nazwa', "asdasd")
ret = check_event(zad, wartosci)
print(zad)
print(ret)
time.sleep(1000)
'''
time.sleep(1)
add2log('mk', 'start', {}, 'green')
backup_power_data(2)
time.sleep(1)
wykonuj_zadania = False
try:
 x = 0
 y = 0
 bkEvent.setTick(0.01)
 for ev in CONFIG_OBJ['events']:		
  if var_get_int(ev, 'zablokuj_start') == 1:
   bkEvent.add(ev['nazwa'], False, 60)#dodanie 60 sekund
 wartosci_old_mqtt = {}
 while True:
  if x % 100 == 0:#co sekunde
   mk_set_sql_values()
  wartosci = get_wartosci(x==0 and y==2)
  bkEvent.tick()
  for ev in CONFIG_OBJ['events']:
   if var_get_int(ev, 'aktywny', 0) == 1 and wykonuj_zadania:
    ret = check_event(ev, wartosci)
    if ret == 1:					
     if bkEvent.check(ev['nazwa']) == 0:
      zadanie_wykonaj(ev, wartosci)
      if var_get_int(ev, 'nie_loguj') != 1:
       add2log('mk', 'event start: '+ev['nazwa'], wartosci, 'red')						
      bkEvent.add(ev['nazwa'], var_get_int(ev, 'zablokuj') == 1, ev['zablokuj_czas'])
    elif ret == 0:
     if bkEvent.check(ev['nazwa']) != 2:#nie odblokuje eventu jak trzyma jeszcze czas
      if int(var_get(ev, 'zablokuj', 0)) == 1 and bkEvent.check(ev['nazwa']) == 1 and var_get_int(ev, 'nie_loguj') != 1:
       add2log('mk', 'event clear: '+ev['nazwa'], wartosci, 'blue')
      bkEvent.delete(ev['nazwa'])
      if ev['akcja'] == 'save2sysnote' and  x % 100 == 0:#co sekunde dla danej akcji
       sys_note.delete(ev['nazwa'])
  x = x+1
  if x % 100 == 0:
   update_variables_by_other_vars(wartosci)
   df = obj_get_diffirence(wartosci, wartosci_old_mqtt)
   if len(df) > 0:
    json_file_save(FILE_MQTT_2SEND, df, True)
   wartosci_old_mqtt = wartosci
   if oledDisplay:
    oledDisplay.addStartText("iHome Controler" + str(' ' * int(x / 100)) +  '>')
    oledDisplay.write()
   rPw = pwmObj.check(json_file_get(FILE_PWM_DATA))
   if rPw != False:
    if rPw['action'] == 'start':
     rPw['obj'].start(rPw['fill']) if PLATFORM == 'rpi' else 12
    elif rPw['action'] == 'fill':
     rPw['obj'].ChangeDutyCycle(int(rPw['fill'])) if PLATFORM == 'rpi' else 12
    elif rPw['action'] == 'stop':
     rPw['obj'].stop() if PLATFORM == 'rpi' else 12
   zadanie_wykonaj_test2do(wartosci)
  if x == 1000:
   wykonuj_zadania = True
   temp_obj = sensnObj.get2update()
   if temp_obj:
    temp = temp_obj.get_temperature() if PLATFORM == 'rpi' else 12
    sensnObj.update(temp)
    sensnObj.save()
   x = 0
   y = y + 1
   rr = evtTime.check()
   if rr:
    zad = var_get_by(CONFIG_OBJ['time'], 'nazwa', rr)
    if zad and var_get_int(zad, 'aktywny') == 1 and check_event(zad, wartosci):
     zadanie_wykonaj(zad, wartosci)
     evtTime.lock(rr, 15)#ponad 2 min
     if int(var_get(zad, 'nie_loguj', '0')) != 1:
      add2log('mk', 'event time: '+zad['nazwa'], wartosci, 'orange')
   if mdate.get_add('h:m') == '00:00':
    sys_note.clear_all()
  if y == 6:
   mk_getStartData()
   sys_workingModules.set('mk')
   y = 0
  time.sleep(0.01)
except KeyboardInterrupt:
 print('Koniec')
 #GPIO.cleanup()