import serial
import threading
import time
class rxtx:
 def __init__(self, _port, _speed = 9600, _timeout = 1):
  self.todo = True
  self.errorStr = ''
  self.addParam = {}
  try:
   self.sObj = serial.Serial(port = _port, baudrate = _speed, timeout=_timeout,
   parity=serial.PARITY_NONE, stopbits=serial.STOPBITS_ONE, bytesize=serial.EIGHTBITS)	
  except:
   self.errorStr = 'unknown port ('+_port+')'
   self.sObj = False
  def read_from_port (sPort):			
   while (self.todo and self.sObj):
    try:
     if sPort.in_waiting > 0:
      if callable(self.onRead):
       ts = str(self.onRead)
       try:
        readString = sPort.readline().decode('ascii', 'ignore').replace("\r\n", "")
        if ts in self.addParam:
         self.onRead(self.addParam[ts], readString)
        else:								
         self.onRead(readString)
       except:
        pass
    except:
     raise
    time.sleep(0.0001)
  self.thread = threading.Thread(target=read_from_port, args=(self.sObj, ))
  self.onRead = False
 def error (self): 
  return False if self.sObj else self.errorStr
 def setReadEvt (self, fn, nn = False):
  if callable(fn):			
   self.onRead = fn
   if nn:
    self.addParam[str(fn)] = nn
 def start (self):
  self.thread.start()
 def stop (self):
  self.todo = False
 def write(self, str):
  if self.sObj:
   try:
    self.sObj.write(str.encode())
    self.sObj.flushInput()
    return True
   except:
    return False
  else:
   return False
 def testEvent(self, txt):
  if callable(self.onRead):
   ts = str(self.onRead)
   if ts in self.addParam:
    self.onRead(self.addParam[ts], txt)
   else:
    self.onRead(txt)