import platform
from threading import Timer
from lib.functions import *
PLATFORM = 'win' if platform.system() == 'Windows' else 'rpi'
if PLATFORM == 'rpi':
 import RPi.GPIO as GPIO
 GPIO.setwarnings(False)
 GPIO.setmode(GPIO.BCM)
class gpioOutIn:
 def __init__(self, obj, tmpDir = ''):
  self.confObj = obj
  self.tmpDir = tmpDir if len(tmpDir) > 0 else False
  for a in self.confObj:
   if a['typ'] == "out_d_0" and len(a['numer']) > 0:
    nr = int(a['numer'])
    if PLATFORM == 'rpi':
     GPIO.setup(nr, GPIO.OUT)
   elif a['typ'] == 'input_d_1' and len(a['numer']) > 0:
    nr = int(a['numer'])
    if PLATFORM == 'rpi':					
     GPIO.setup(nr, GPIO.IN, pull_up_down=GPIO.PUD_UP)
 def out_get(self, n):
  for a in self.confObj:
   if a['nazwa'] == n:
    if self.tmpDir:
     return self.txt_var_get(n)
    else:
     nx = int(a['numer'])
     return int(GPIO.input(nx))
  return 0
 def in_get(self, n):
  for a in self.confObj:
   if a['nazwa'] == n:
    if self.tmpDir:
     return self.txt_var_get(n)
    else:
     nx = int(a['numer'])
     return int(GPIO.input(nx))
  return 0
 def out_set_toggle(self, n):
  for a in self.confObj:
   if a['nazwa'] == n:
    if self.tmpDir:
     cr = self.txt_var_get(n)
     self.txt_var_set(n, 0 if cr ==1 else 1)
     if len(a['czas']) > 0 and int(a['czas']) > 0:
      Timer(int(a['czas']), self.mk_tm, (a['nazwa'], 0 if cr != 1 else 1)).start()					
    else:
     nr = int(a['numer'])
     act = int(GPIO.input(nr))
     if len(a['czas']) > 0 and int(a['czas']) > 0:
      Timer(int(a['czas']), self.mk_tm, (a['nazwa'], 0 if act != 1 else 1)).start()
     if act != 1:
      GPIO.output(nr, GPIO.HIGH)
     else:
      GPIO.output(nr, GPIO.LOW)
 def out_set(self, n, v):
  for a in self.confObj:
   if a['nazwa'] == n:
    if len(a['czas']) > 0 and int(a['czas']) > 0:
     Timer(int(a['czas']), self.mk_tm, (n, 0 if v == 1 else 1)).start()
    if self.tmpDir:
     self.txt_var_set(n, v)
    else:
     GPIO.output(int(a['numer']), GPIO.HIGH if v == 1 else GPIO.LOW)
 def mk_tm(self, n, v):
  for a in self.confObj:
   if a['nazwa'] == n:		
    GPIO.output(int(a['numer']), GPIO.HIGH if v == 1 else GPIO.LOW);		
 def txt_var_get(self, n):
  try:
   return int(file_read(self.tmpDir + 'gpio_'+n+'.gpio', '0'))
  except Exception as e:
   return 0
 def txt_var_set(self, n, v):
  return file_save(self.tmpDir + 'gpio_'+n+'.gpio', '1' if v == 1 else '0')	
 def backup_get(self):
  ret = {}
  for a in self.confObj:
   if a['typ'] == "out_d_0" and len(a['numer']) > 0:
    n = a['nazwa']
    pin = self.out_get(n)
    if pin == 1:
     ret[n] = 1
  return ret
 def backup_set(self, obj):
  for a in self.confObj:
   if a['typ'] == "out_d_0" and len(a['numer']) > 0:
    n = a['nazwa']
    if n in obj:
     self.out_set(n, obj[n])
