import sqlite3
class msqlLite:
 def __init__ (self, path, dot_n = ''):
  self.conn = sqlite3.connect(path + 'ric'+('_'+dot_n if len(dot_n) else '')+'.sqlite', isolation_level=None, check_same_thread=False, timeout=10)#, isolation_level=None)
  self.conn.cursor()
  self.err = False
  self.dbTables = []
  if dot_n == 'reply':
   self.setTables(['rs485', 'i2c', 'rflink', 'zigbee'])
  elif dot_n == 'work':
   self.setTables(['boiler_ot'])
  else:
   self.setTables(['rs485', 'rs485_cmd', 'i2c', 'i2c_cmd', 'http_2send', 'events_2do', 'rflink', 'rflink_cmd', 'devices', 'pings', 'zigbee', 'zigbee_cmd', 'vars_exp'])
 def setTables(self, tables = []):		
  self.dbTables = tables
  self._create_tables()
 def insertVal(self, t, n, v):
  self.err = False
  if t in self.dbTables:
   try:
    c = self.conn.cursor()
    c.execute('INSERT INTO '+t+' (n, v) VALUES (\''+n+'\', \''+str(v)+'\')')
    self.conn.commit()
   except Exception as e:
    self.err = e
 def setValArr(self, t, n, v, sep=','):
  self.setVal(t, n, sep.join(v))	
 def setVal(self, t, n, v):
  self.err = False
  if t in self.dbTables:
   try:			
    c = self.conn.cursor()
    ot = c.execute('SELECT * FROM '+t+' WHERE n=\''+n+'\'')
    if len(ot.fetchall()) == 0:				
     c.execute('INSERT INTO '+t+' (n, v) VALUES (\''+n+'\', \''+str(v)+'\')')
    else:
     c.execute('UPDATE '+t+' SET v=\''+str(v)+'\' WHERE n=\''+n+'\'')
    self.conn.commit()
   except Exception as e:
    self.err = e			
 def setValues(self, t, obj, opts = {}):
  self.err = False
  if t in self.dbTables:
   is_clear = self._get_int(opts, 'clear')
   exists = {} if is_clear == 1 else self.getValues(t)
   try:
    c = self.conn.cursor()
    if is_clear == 1:
     c.execute('DELETE FROM '+t+'')
    for a in obj:
     if a in exists:
      c.execute('UPDATE '+t+' SET v=\''+str(obj[a])+'\' WHERE n=\''+a+'\'')
     else:
      c.execute('INSERT INTO '+t+' (n, v) VALUES (\''+a+'\', \''+str(obj[a])+'\')')
    self.conn.commit()
   except Exception as e:
    self.err = e
 def setSortLimit(self, t, ob, lmt=10):
  try:
   ks = sorted(ob, reverse=True)
   new  = {};
   ins = []
   for i in range(len(ks)):
    if i < lmt:
     ins.append('(\''+str(ks[i])+'\', \''+str(ob[ks[i]])+'\')');
     new[ks[i]] = ob[ks[i]]		
   c = self.conn.cursor()
   c.execute('DELETE FROM '+t+';')
   c.execute('INSERT INTO '+t+' (n, v) VALUES ' + ','.join(ins) + ';')
   self.conn.commit()
   return new
  except Exception as e:
   self.err = e
   return ob
 def getValArr(self, t, n, _def=[], sep = ','):
  _tmp = self.getVal(t, n, False)
  return _tmp.split(sep) if _tmp != False else _def
 def getVal(self, t, n, _def=False):
  ret = _def
  self.err = False
  if t in self.dbTables:
   try:
    c = self.conn.cursor()
    res = c.execute('select * from '+t+' WHERE n=\''+n+'\'')
    obj = res.fetchall()
    for a in obj:
     return a[1]
   except Exception as e:
    self.err = e
  return ret
 def getValDel(self, t, n, _def=False):
  ret = _def
  self.err = False
  if t in self.dbTables:
   try:
    c = self.conn.cursor()
    res = c.execute('select * from '+t+' WHERE n=\''+n+'\'')
    obj = res.fetchall()
    for a in obj:
     self.delVal(t, n)
     return a[1]
   except Exception as e:
    self.err = e
  return ret
 def getValues(self, t):
  ret = {}
  if t in self.dbTables:
   try:
    c = self.conn.cursor()
    res = c.execute('select * from '+t+'')
    names = list(map(lambda x: x[0], res.description))
    obj = res.fetchall()
    for a in obj:
     ret[a[0]] = a[1]
   except Exception as e:
    self.err = e
  return ret
 def delVal(self, t, n):
  if t in self.dbTables:
   try:
    c = self.conn.cursor()
    if type(n) is str:
     c.execute('DELETE FROM '+t+' WHERE n=\''+n+'\'')
    elif type(n) is list:
     for k in n:
      c.execute('DELETE FROM '+t+' WHERE n=\''+k+'\'')
    self.conn.commit()
   except Exception as e:
    self.err = e
 def clear(self, t):
  if t in self.dbTables:
   try:
    c = self.conn.cursor()
    c.execute('DELETE FROM '+t+'')
    self.conn.commit()
   except Exception as e:
    self.err = e
 def _create_tables(self):
  exists = self._get_exists_tables()
  try:		
   c = self.conn.cursor()
   for a in self.dbTables:
    if a not in exists:
     c.execute('''CREATE TABLE '''+a+''' (n TEXT, v TEXT)''')
   self.conn.commit()
  except Exception as e:
   self.err = e
 def _get_exists_tables(self):
  ret = []
  try:
   c = self.conn.cursor()
   c.execute('SELECT name FROM sqlite_master WHERE type=\'table\';')
   res = c.fetchall()
   for a in res:
    ret.append(str(a).replace(',','').replace('\'','').replace('(','').replace(')',''))		
  except Exception as e:
   self.err = e
  return ret
 @staticmethod
 def _get_int(a, b, c = 0):
  try:
   return int(a[b])
  except:
   return c