import paho.mqtt.client as mqtt
def mqttSendOne(obj, topic, msg='', fn=False):
 def vg(o, n, d=''):
  return o[n] if n in o else d
 _serv = vg(obj, 'server', 'localhost')
 _port = int(vg(obj, 'port', 8888))
 _prefix = vg(obj, 'prefix')
 _ident = vg(obj, 'ident')
 _user = vg(obj, 'user')
 _passwd = vg(obj, 'passwd')	
 mqttObj = mqttBroker(_serv, _port, 'ihome_mqtt_send_one')	
 def evtFn(a, b):
  if a == 'connect':
   topic_prefix = (_prefix + '/' if len(_prefix)>0 else '') + (_ident + '/' if len(_ident)>0 else '')
   if type(topic) is dict:
    for a in topic:
     mqttObj.publish(topic_prefix + a, topic[a])
   else:
    mqttObj.publish(topic_prefix + topic, msg)
   mqttObj.close()
   if callable(fn):
    fn(True)
 mqttObj.setFunctionEvt(evtFn)
 mqttObj.connect(_user, _passwd)
class mqttBroker:
 def __init__ (self, server, port, client_id):
  self.c_server = server
  self.c_port = port
  self.c_client_id = client_id
  self.c_user = ''
  self.c_passwd = ''
  self.t_client = ''
  self.t_device = ''
  self.onMessage = False
  self.onEvt = False
  self.is_connect = False
  self.subscribeTopic = {'name' : '', 'qos' : 0}
  self.mq = mqtt.Client(client_id)
 def setClientDevice(self, a='', b=''):
  self.t_client = a
  self.t_device = b
 def setSubscribe (self, topic, qos = 0):
  topic = self._createTopic(topic)
  self.subscribeTopic = {'name' : topic, 'qos' : qos}
 def setFunctionMsg (self, fn):
  if callable(fn):
   self.onMessage = fn
 def setFunctionEvt (self, fn):
  if callable(fn):
   self.onEvt = fn
 def publish (self, topic, msg, qos = 0, retain = False):
  topic = self._createTopic(topic)
  self.mq.publish(topic, msg, qos, retain)
 def connect (self, user = '', passwd = ''):
  self.c_user = user
  self.c_passwd = passwd
  if len(self.c_user) > 0 and len(self.c_passwd) > 0:
   self.mq.username_pw_set(self.c_user, self.c_passwd)
  self.mq.on_connect = self._onconnect
  self.mq.on_disconnect  = self._ondisconnect
  self.mq.on_message = self._onmessage		
  try:
   connId = self.mq.connect(self.c_server, self.c_port, 10)
  except Exception as e:
   connId = False
  self.mq.loop_start()
  return connId
 def close(self):
  self.mq.disconnect()
 def _onmessage(self, client, userdata, message):
  strm = str(message.payload.decode("utf-8"))
  topic = message.topic
  if len(self.t_device) > 0 or len(self.t_client) > 0:
   t = topic.split('/')
   if len(self.t_client) > 0:
    t.pop(0)
   if len(self.t_device) > 0:
    t.pop(0)
   topic = '/'.join(t)
  self.onMessage(self, topic, strm)
 def _onconnect(self, client, userdata, flags, rc):
  self._sendEvt('connect')
  if self.is_connect == False:
   self.is_connect = True
   if len(self.subscribeTopic['name']) > 0:				
    self.mq.	subscribe(self.subscribeTopic['name'], self.subscribeTopic['qos'])#or 0 ????
 def _ondisconnect(self, client, userdata, rc):
  self._sendEvt('disconnect');
  self.is_connect = False
 def _sendEvt(self, t, s=''):
  if callable(self.onEvt):
   self.onEvt(t, s)
 def _createTopic(self, topic):
  if type(topic) is list:
   t = topic
  else:
   t = topic.split('/')
  if len(self.t_device) > 0:
   t.insert(0, self.t_device)
  if len(self.t_client) > 0:
   t.insert(0, self.t_client)
  return '/'.join(t)
