import time
import subprocess
import os.path
import platform
import os.path
class disp_ssd_adds(object):
 def get_cmd(t):
  if platform.system() == 'Windows':
   return 'cmd: ' + t
  else:
   if t == 'hostname':
    cmd = "hostname -I"
    return subprocess.check_output(cmd, shell = True)
   elif t == 'cpu':
    cmd = "top -n 1 -b | awk '/^%Cpu/{print $2}'"
    return subprocess.check_output(cmd, shell = True)
   elif t == 'mem':
    cmd = "free -m | awk 'NR==2{printf \"%s/%s MB   %.2f%%\", $3,$2,$3*100/$2 }'"
    return subprocess.check_output(cmd, shell = True)
   elif t == 'disk':
    cmd = "df -h | awk '$NF==\"/\"{printf \"%d/%d GB   %s\", $3,$2,$5}'"
    return subprocess.check_output(cmd, shell = True )	
if platform.system() != 'Windows':
 import Adafruit_GPIO.SPI as SPI
 import Adafruit_SSD1306
 from PIL import Image
 from PIL import ImageDraw
 from PIL import ImageFont
 class disp_ssd1306:
  def __init__ (self, i2c_address=0x3C, use_minecrafta = False):
   self._options = []
   self.StartText = '';
   try:
    self.disp = Adafruit_SSD1306.SSD1306_128_64(rst=None, i2c_address=i2c_address )		
    self.disp.begin()
    self.disp.clear()
    self.disp.display()
    self.width = self.disp.width
    self.height = self.disp.height
    self.image = Image.new('1', (self.width, self.height))
    self.draw = ImageDraw.Draw(self.image)
    self.draw.rectangle((0, 0, self.width, self.height), outline=0, fill=0)
    self.top = -2
    self.left = 0
    self.fontSize = 8
    self.linePadding = 2
    self.font = ImageFont.load_default()
    if use_minecrafta:
     this_path = os.path.abspath(os.path.join(os.path.dirname( __file__ )))+"/"
     ttf_file = this_path + 'minecraftia-regular.ttf'				
     if os.path.isfile(ttf_file):
      self.font = ImageFont.truetype(ttf_file, self.fontSize)	
   except:
    self.disp = False
  def setOptions(self, opt):
   self._options = opt
  def addStartText(self, str):
   self.StartText = str;			
  def chStr(self, txt):
   s = str(txt);
   s = s.replace('b\'', '')
   s = s.replace(' \\n\'', '')
   s = s.replace('\\n\'', '')
   s = s.strip()
   return s;
  def write(self, extraText = []):
   if self.disp:
    self.draw.rectangle((0 , 0 , self.width, self.height), outline=0, fill=0)
    ile = 0
    if len(self.StartText) > 0:
     self.draw.text((0, self.top), self.StartText,  font=self.font, fill=1)
     ile = ile + 1
    if 'ip' in self._options:
     _hostname = disp_ssd_adds.get_cmd('hostname')
     y = self.top+(self.fontSize+self.linePadding)*ile
     self.draw.text((0, y),       "IP:   " +self.chStr(_hostname),  font=self.font, fill=1)
     ile = ile+1
    if 'cpu' in self._options:
     _cpu = disp_ssd_adds.get_cmd('cpu')
     y = self.top+(self.fontSize+self.linePadding)*ile
     self.draw.text((0, y),     "CPU:   " + self.chStr(_cpu) + " %", font=self.font, fill=255)
     ile = ile+1
    if 'mem' in self._options:
     _mem = disp_ssd_adds.get_cmd('mem')
     y = self.top+(self.fontSize+self.linePadding)*ile
     self.draw.text((0, y),    "Mem:   " + self.chStr(_mem),  font=self.font, fill=255)
     ile = ile+1
    if 'disk' in self._options:
     _disk = disp_ssd_adds.get_cmd('disk')
     y = self.top+(self.fontSize+self.linePadding)*ile
     self.draw.text((0, y),    "Disk:   " + self.chStr(_disk),  font=self.font, fill=255)
     ile = ile+1
    if len(extraText) > 0:
     for a in extraText:
      y = self.top+(self.fontSize+self.linePadding)*ile
      self.draw.text((0, y), a,  font=self.font, fill=255)
      ile = ile+1
    try:			
     self.disp.image(self.image)
     self.disp.display()	
     return True
    except:
     return False
   else:
    return False
else:
 class disp_ssd1306:		
  def __init__ (self, i2c_address=0x3C, fontPath=''):
   self._options = []
   self.StartText = '';
  def setOptions(self, opt):
   self._options = opt
  def addStartText(self, str):
   self.StartText = str;
  def write(self, extraText = []):
   _hostname = disp_ssd_adds.get_cmd('hostname')
   _cpu = disp_ssd_adds.get_cmd('cpu')
   _mem = disp_ssd_adds.get_cmd('mem')
   _disk = disp_ssd_adds.get_cmd('disk')			
'''
   print('----------', 'display-start', '----------')
   if len(self.StartText) > 0:
    print(self.StartText)
   if 'ip' in self._options:
    print('|', _hostname)
   if 'cpu' in self._options:
    print('|', _cpu)
   if 'mem' in self._options:
    print('|', _mem)
   if 'disk' in self._options:
    print('|', _disk)
   if len(extraText) > 0:
    for a in extraText:
     print('|', a)
   print('----------', 'display-stop', '----------')
'''
