import os
import sys
import time
import subprocess
import platform
import json
ROOT_DIR = os.path.abspath(os.path.join(os.path.dirname( __file__ ), '..'))+"/"
sys.path.append(ROOT_DIR + 'pt/')
from _config_top import *
from lib.functions import *
def sys_print_msg(msg):
 c = {
 'HEADER' : '\033[95m',
 'OKBLUE' : '\033[94m',
 'OKCYAN' : '\033[96m',
 'OKGREEN' : '\033[92m',
 'WARNING' : '\033[93m',
 'FAIL' : '\033[91m',
 'ENDC' : '\033[0m',
 'BOLD' : '\033[1m',
 'UNDERLINE' : '\033[4m'
 }
 print(c['HEADER'] + "Warning: No active frommets remain. Continue?" + c['ENDC'])	
def sys_rb_get_all_information(is_json = False):#only for mqtt
 _dev = sys_info.get_usage()
 _mod = sys_workingModules.get()
 _sys = sys_info.info()
 ret = {
  'System' : _sys,
  'Urzadzenie' : _dev,
  'Moduly' : _mod
 }
 if is_json:
 		return json.dumps(ret)
 else:
  return ret;
def sys_get_info(t):
 if platform.system() == 'Windows':
  return 'cmd: ' + t
 else:
  try:
   if t == 'hostname':
    cmd = "hostname -I"
    ret = subprocess.check_output(cmd, shell = True).decode('utf-8')
   elif t == 'cpu':
    cmd = "top -n 1 -b | awk '/^%Cpu/{print $2}'"
    ret = subprocess.check_output(cmd, shell = True).decode('utf-8')
   elif t == 'mem':
    cmd = "free -m | awk 'NR==2{printf \"%s/%s MB\", $3,$2}'"
    ret = subprocess.check_output(cmd, shell = True).decode('utf-8')						
   elif t == 'mem_proc':
    cmd = "free -m | awk 'NR==2{printf \"%.2f\", $3*100/$2}'"
    ret = subprocess.check_output(cmd, shell = True).decode('utf-8')
   elif t == 'disk':
    cmd = "df -h | awk '$NF==\"/\"{printf \"%d/%d GB\", $3,$2}'"
    ret = subprocess.check_output(cmd, shell = True ).decode('utf-8')
   elif t == 'disk_proc':
    cmd = "df -h | awk '$NF==\"/\"{printf \"%s\", $5}'"
    ret = subprocess.check_output(cmd, shell = True ).decode('utf-8')	
    ret = ret.replace('%', '')
   else:
    ret = str('cmd: ' + t)
   return ret.replace('\n', '')
  except Exception as e:
   return 'cmd-err: ' + t
class sys_conn_error:
 _fname = 'global_err_data.json'
 def set(t, n = ''):
  f = sys_info._dir(sys_conn_error._fname)
  obj = json_file_get(f)
  v = ','.join(n) if type(n) is list else n
  if len(v)>0:
   obj[t] = str(v)
  else:
   if t in obj:
    del obj[t]
  json_file_save(f, obj)
 def is_err():
  obj = json_file_get(sys_info._dir(sys_conn_error._fname))
  return len(obj) > 0
 def get():
  obj = json_file_get(sys_info._dir(sys_conn_error._fname))
  ret = []
  for a in obj:
   ret.append(a+':'+str(obj[a]))
  i = len(obj)
  return '|'.join(ret)
class sys_info:
 def set_usage():
  d = sys_info._dir()
  f = d + "sys_info_usage.json"
  obj = {'cpu' : sys_get_info('cpu'),  'mem' : sys_get_info('mem'), 'mem_p' : sys_get_info('mem_proc'), 'disk' : sys_get_info('disk'), 'disk_p' : sys_get_info('disk_proc')}			
  if os.path.isdir(d):
   json_file_save(f, obj)
 def get_usage():
  return json_file_get(sys_info._dir("sys_info_usage.json"))	
 def ram_disk_check():
  global RAM_DISK_PATH
  file_check = RAM_DISK_PATH + '_sys_info__check_save_data.txt'
  file_create_if_no(file_check, 'test')
  ret = 'ok' if file_read(file_check) == 'test' else '-blad zapisu danych-'
  os.remove(file_check)		
  return ret
 def info():
  ret = {}		
  ret['aktualna data'] = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
  ret['wersja'] = mk_php('index.php', 'info version')
  ret['aktualizacja'] = mk_php('index.php', 'info update_date')
  return ret
 def _dir(f = ''):
  global DIR_QUICK_MEM
  return DIR_QUICK_MEM + f
class sys_note:
 _fname = 'sys_note_data.json'
 _time_lock = 60#sekundy
 def write(idn, msg):
  f = sys_info._dir(sys_note._fname)
  t = file_last_save(f)
  obj = json_file_get(f)		
  if type(obj) is dict:
   if idn not in obj or t == -1 or t >= sys_note._time_lock:
    obj[idn] = str(msg)
    json_file_save(f, obj)
  else:
   json_file_save(f, {idn:msg})
 def delete(idn):
  f = sys_info._dir(sys_note._fname)
  t = file_last_save(f)
  obj = json_file_get(f)
  if type(obj) is dict and idn in obj and t != -1 and t >= sys_note._time_lock:
   del obj[idn]
   json_file_save(f, obj)			
 def clear_all():
  f = sys_info._dir(sys_note._fname)
  t = file_last_save(f)
  if t > 1:
   file_del(f)
 def get():
  f = sys_info._dir(sys_note._fname)
  obj = json_file_get(f)
  ret = []
  if type(obj) is dict:
   for a in obj:
    ret.append(obj[a])
  return ret
class sys_err:
 def init():
  f = sys_err._f()
  json_file_save(f, {})
 def set(n, v):
  f = sys_err._f()
  obj = json_file_get(f)
  obj[n] = v
  json_file_save(f, obj)
 def get_all():
  f = sys_err._f()
  obj = json_file_get(f)
  return obj
 def _f():
  global FILE_VARIABLES_SYS_ERR
  return FILE_VARIABLES_SYS_ERR
class sys_var_const():
 def init():
  f = sys_var_const._f()
  json_file_save(f, {})
 def set(n, v):
  f = sys_var_const._f()
  obj = json_file_get(f)
  obj[n] = v
  json_file_save(f, obj)
 def get_all():
  f = sys_var_const._f()
  obj = json_file_get(f)
  return obj
 def _f():
  global FILE_VARIABLES_CONST
  return FILE_VARIABLES_CONST
class sys_var_spec():
 def init():
  f = sys_var_spec._f()
  json_file_save(f, {})
 def set(n, v):
  f = sys_var_spec._f()
  obj = json_file_get(f)
  obj[n] = v
  json_file_save(f, obj)
 def get_all():
  f = sys_var_spec._f()
  obj = json_file_get(f)
  return obj
 def _f():
  global FILE_VARIABLES_SPECIAL
  return FILE_VARIABLES_SPECIAL
def add2log(mod, n='', z = {}, c = False):#module, name, values, color
 global FILE_LOG
 sys_add2logfunction(FILE_LOG, mod, n, z, c, True)
def add2loguser(mod, n, z = {}, c = False):
 global FILE_LOG_USER
 sys_add2logfunction(FILE_LOG_USER, mod, n, z, c)
def sys_add2logfunction(json_file, mod, n='', z = {}, c = False, addCount = False):
 if mod == False:
  obj = []
 else:		
  obj = json_file_get(json_file, [])
  if len(obj) > 0 and obj[0]['name'] == n and obj[0]['mod'] == mod and addCount:
   obj[0]['count'] = obj[0]['count'] + 1
   obj[0]['date_list'].insert(0, datetime.now().strftime("%Y-%m-%d %H:%M:%S"))
  else:
   obj.insert(0, {'mod' : mod, 'name' : n, 'data' : z, 'date' : datetime.now().strftime("%Y-%m-%d %H:%M:%S"), 'date_list':[], 'count' : 1, 'color' : c})
  if len(obj) > 200:
   del obj[-1]
 json_file_save(json_file, obj)
class sys_workingModules:
 elem = ['mk', 'mk2', 'devices', 'i2c', 'rs485', 'mqtt', 'ports', 'pings', 'rflink', 'boiler_ot', 'zigbee']
 def set(n):		
  try:
   if n in sys_workingModules.elem:
    t = str(int(time.time()))
    f = sys_workingModules._get_file(n)
    if f != False:
     file_save(f, t)
  except Exception as e:
   pass
 def get():
  ret = {}
  now = int(time.time())
  for a in sys_workingModules.elem:			
   f = sys_workingModules._get_file(a)
   if f != False:
    try:
     sec = int(file_read(f, "0"))		
    except Exception as e:
     sec = 0
    r = (now - sec)
    ret[a] = 'ok' if r < 130 else '-'
   else:
    ret[a] = '?'
  return ret
 def is_err():
  obj = sys_workingModules.get()
  for a in obj:
   if obj[a] == '-':
    return True
  return False
 def getErr():
  ret = []
  obj = sys_workingModules.get()
  for a in obj:
   if obj[a] == '-':
    ret.append(a)
  return ','.join(ret)
 def getStr():
  obj = sys_workingModules.get()
  em = []
  for a in obj:
   em.append(a + ':' + obj[a])
  return '|'.join(em)
 def _get_file(n):
  global DIR_QUICK_MEM
  f = DIR_QUICK_MEM + "work_mod_"+n+".t"
  if os.path.isdir(DIR_QUICK_MEM):
   return f
  else:
   return False
