import sys
import os
from datetime import datetime
import time
import platform
PLATFORM = 'win' if platform.system() == 'Windows' else 'rpi'
ROOT_DIR = os.path.abspath(os.path.join(os.path.dirname( __file__ ), '..'))+"/"
sys.path.append(ROOT_DIR + 'pt/')
from lib.functions import *
from lib.fn import *
from lib.msqllite import msqlLite
from lib.connErr_class import connErr
from lib.devices_do_class import devices_do
from lib.value_class import value
FILE_CONFIG = ROOT_DIR + "confs/config.json"
CONFIG_OBJ = json_file_get(FILE_CONFIG)
_param_main = var_get(CONFIG_OBJ, 'parameters.main', {})
_param_idents = var_get(CONFIG_OBJ, 'parameters.idents', {})
_param_oled = var_get(CONFIG_OBJ, 'parameters.oled', {})
_param_mqtt = var_get(CONFIG_OBJ, 'parameters.mqtt', {})
RAM_DISK_PATH = var_get(_param_main, 'ram_disk_path', '')
BROADCAST_IP = var_get(_param_main, 'broadcast_ip');
DEVICE_ADDR = var_get(_param_main, 'device_addr');
IHOME_URL = 'https://ihome.net2me.pl/'
IHOME_IDENT = var_get(_param_idents, 'ihome_ident')
IHOME_KEY = var_get(_param_idents, 'ihome_key')
OPENWEATHERMAP_KEY = var_get(_param_idents, 'openweathermap_key', '')
LOCALIZATION_LAT = var_get(_param_idents, 'localization_lat', '')
LOCALIZATION_LONG = var_get(_param_idents, 'localization_long', '')
OLED_PARAMS = {
 'addr' : var_get(_param_oled, 'display_addr', ''),
 'options' : var_get(_param_oled, 'display_options', []),
}
_mq = ['server', 'port', 'prefix', 'ident', 'user', 'passwd', 'aktywny']
MQTT_PARAMS = {}
for a in _mq:
 MQTT_PARAMS[a] = var_get(_param_mqtt, a, '')
del _param_main, _param_idents, _param_oled, _param_mqtt
SQL_PATH = RAM_DISK_PATH if len(RAM_DISK_PATH)>0 else ROOT_DIR + "data/"
FILE_REPOSITORY = ROOT_DIR + "data/repository.json"
FILE_LOG = RAM_DISK_PATH + "log.json" if len(RAM_DISK_PATH) > 0 else ROOT_DIR + "data/log.json"
FILE_LOG_USER = RAM_DISK_PATH + "log_user.json" if len(RAM_DISK_PATH) > 0 else ROOT_DIR + "data/log_user.json"
FILE_SENSORS = RAM_DISK_PATH + "sensors.json" if len(RAM_DISK_PATH)>0 else ROOT_DIR + "data/sensors.json"
FILE_PWM_DATA = RAM_DISK_PATH + "pwm.json" if len(RAM_DISK_PATH) > 0 else ROOT_DIR + "data/pwm.json"
FILE_DEVICES_DATA = RAM_DISK_PATH + "devices.json" if len(RAM_DISK_PATH) > 0 else ROOT_DIR + "data/devices.json"
FILE_CAMERAS_DATA = RAM_DISK_PATH + "cameras.json" if len(RAM_DISK_PATH) > 0 else ROOT_DIR + "data/cameras.json"
FILE_PORTS_DATA = RAM_DISK_PATH + "ports.json" if len(RAM_DISK_PATH) > 0 else ROOT_DIR + "data/ports.json"
FILE_PORTS2DO_DATA = RAM_DISK_PATH + "ports2do.json" if len(RAM_DISK_PATH) > 0 else ROOT_DIR + "data/ports2do.json"
FILE_MQTT_2SEND = RAM_DISK_PATH + "mqtt2send.json" if len(RAM_DISK_PATH) > 0 else ROOT_DIR + "data/mqtt2send.json"
FILE_MQTT_2SEND_ONE = RAM_DISK_PATH + "mqtt2sendone.json" if len(RAM_DISK_PATH) > 0 else ROOT_DIR + "data/mqtt2sendone.json"
FILE_CHECK_MODS = RAM_DISK_PATH + "ric_check_mods.json" if len(RAM_DISK_PATH) > 0 else ROOT_DIR + "data/ric_check_mods.json"
DIR_QUICK_MEM = RAM_DISK_PATH + "_quick_memory/" if len(RAM_DISK_PATH) > 0 else ROOT_DIR + "_quick_memory/"
FILE_VARIABLES_CONST = RAM_DISK_PATH + "variables_const.json"
FILE_VARIABLES_SPECIAL = RAM_DISK_PATH + "variables_spec.json"
FILE_VARIABLES_SYS_ERR = RAM_DISK_PATH + "variables_err_sys.json"
if DIR_QUICK_MEM != False:
 if os.path.isdir(DIR_QUICK_MEM) == False:
  os.mkdir(DIR_QUICK_MEM)
from _sys import *
from _vars_ex import *
