<?php

class curl
{
	public static function get_simple($url, $timeout = false)
	{
		$x = self :: get($url, false, $timeout);
		return $x[0];
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function get($url, $ret_type = false, $timeout = false, $opt = array())
	{
		return self :: _curl_action($url, 'get', false, $ret_type, $timeout, $opt);
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function post($url, $params, $ret_type = false, $timeout = false)
	{
		return self :: _curl_action($url, 'post', $params, $ret_type, $timeout);
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function image($url, $timeout = false, $opt = array())
	{
		return self :: _curl_action($url, 'get', array(), 'image', $timeout, $opt);
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function image_b64($url, $timeout = false, $opt = array())
	{
		return self :: _curl_action($url, 'get', array(), 'image_b64', $timeout, $opt);
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	private static function _curl_action($url, $type = false, $params=null, $ret_type = false, $timeout = false, $options = array())
	{
		$ch = curl_init($url);
		
		curl_setopt($ch, CURLOPT_HEADER, 0);		
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

		if(isset($options['login']) && isset($options['passwd']))
		{
			curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
			
			if($options['login'] > '' && $options['passwd'] > '')
				curl_setopt($ch, CURLOPT_USERPWD, $options['login'] . ":" . $options['passwd']);
		}			

		if($type == 'post')
		{
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
		}
		else
		{
			curl_setopt($ch, CURLOPT_POST, 0);
		}
		
		if($timeout !== false)
			curl_setopt($ch, CURLOPT_TIMEOUT, $timeout? $timeout : 10);
		
		$output = curl_exec($ch);
		$err = curl_error($ch);
		curl_close($ch);	

		if($output > '')
		{
			if($ret_type == 'json')
				$output = json_decode($output, true);
			else if($ret_type == 'xml')
			{
				$output = simplexml_load_string($output);
				$output = get_object_vars($output);
			}
			else if($ret_type == 'image_b64')
			{
				if(strlen($output) < 1000)
					return array(false, $output);					
				
				$output = base64_encode($output);
			}

			if($ret_type == 'image' && strlen($output) < 1000)
				return array(false, $output);	

			return array(true, $output);
		}
		else
			return array(false, $err);		
	}
}

?>