<?php

/*	..................................	

	klasa obsługi tablic
	autor: Marcin Łukasiewicz

	ver.: 1.91
	update: 2016-01-25
*/


class arr
{
	public static function ch_key($arr, $k, $add_k = false, $add_v = false)
	{
		$n = array();
		foreach($arr as $v)
		{
			if(array_key_exists($k, $v))
			{
				$n[$v[$k]] = $v;

				if($add_k)
					$n[$v[$k]][$add_k] = $add_v;
			}
		}
	
		return $n;
	}

	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	
	public static function sort_by($arr, $by, $typ = 1, $s_type=SORT_NUMERIC)
	{
		$n = array();
		$ret = array();
		
		//nowa tablica te same klucze i tylko wartooci
		foreach($arr as $k => $v)
			$n[$k] = $v[$by];
		
		//sortowanie z zachowaniem kluczy
		if($typ == 1)
			asort($n, $s_type);
		else
			arsort($n, $s_type);
		
		//nowa tablica z zachowaniem kluczy pocz1tkowych
		foreach($n as $k => $v)
			$ret[$k] = $arr[$k];
	
		
		return $ret;
	}
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	public static function sort_by_values($arr, $by, $dane)
	{
		//nowa tablica te same klucze i tylko wartooci
		$n = array();
		foreach($arr as $k => $v)
			$n[$k] = $v[$by];
		
		$n1 = array();
		
		foreach($dane as $m)
		{
			foreach($n as $k => $v)
			{
				if($v == $m)
				{
					$n1[$k] = $v;
					unset($n[$k]);
				}
			}
		}
		
		//pozostale	 - tych co nie ma w danych
		foreach($n as $k => $v)
			$n1[$k] = $v;
		
		$ret = array();
		//nowa tablica z zachowaniem kluczy pocz1tkowych
		
		foreach($n1 as $k => $v)
			$ret[$k] = $arr[$k];
		
		return $ret;
	}
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	
	public static function sort_by_keys($arr, $dane)
	{
		//nowa tablica te same klucze i tylko wartooci
		foreach($arr as $k => $v)
			$n[$k] = $v;
		
		$n1 = array();
		
		foreach($dane as $m)
		{
			foreach($n as $k => $v)
			{
				if($k == $m)
				{
					$n1[$k] = $v;
					unset($n[$k]);
				}
			}
		}
		
		//pozostale	 - tych co nie ma w danych
		foreach($n as $k => $v)
			$n1[$k] = $v;
		
		$ret = array();
		//nowa tablica z zachowaniem kluczy pocz1tkowych
		
		foreach($n1 as $k => $v)
			$ret[$k] = $arr[$k];
		
		return $ret;
	}	
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	public static function ch_key_array($arr, $k, $add_k = false, $add_v = false)
	{
		$n = array();
		foreach($arr as $ok => $v)
		{
			if($add_k)
				$arr[$ok][$add_k]= $add_v;	
			
			if(!array_key_exists($v[$k], $n))
				$n[$v[$k]] = array();
			
			$n[$v[$k]][$ok] = $v;
		}

		$arr = $n;
		unset($n);
		return $arr;
	}

	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	public static function simple($arr, $keys, $sep = " ")
	{
		$n = array();
		
		$pka = explode(',', $keys);
		
		foreach($arr as $k => $v)
		{
			$nv = array();

			foreach($pka as $key)
			{
				$key = trim($key);

				if(array_key_exists($key, $v))
					$nv[] = $v[$key];
			}
			
			if($sep)
				$n[$k] = join($sep, $nv);
			else if($sep === false)
			{
				foreach($nv as $x)
					$n[] = $x;
			}
			
			
			unset($nv);
		}
	
		return $n;
	}
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	public static function simple_one($arr, $key)
	{
		$n = array();
		
		foreach($arr as $k => $v)
		{
			if(array_key_exists($key, $v))
				$n[$k] = $v[$key];
		}
	
		return $n;
	}	

	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	
	public static function normal($arr, $nk, $nv, $sep=' ')
	{
		$arr = self :: ch_key($arr, $nk);
		$arr = self :: simple($arr, $nv, $sep);
		
		return $arr;
	}
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 	
	
	public static function first($arr, $mk, $mv='')
	{
		$n[$mk] = $mv;
		$i = 0;
		foreach($arr as $k => $v)
		{
			if($i == 0 && array_key_exists($mk, $arr))
				{}
			else
				$n[$k] = $v;

			$i++;
		}

		$arr = $n;
		unset($n);
		return $arr;
	}
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	
	public static function get($o, $k, $n = false, $len = false)
	{		
		return (is_array($o) && array_key_exists($k, $o))? ($len? ($o[$k] > ''? $o[$k] : $n) : $o[$k]) : $n ;
	}
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	
	public static function getm($obj, $n, $def = false)
	{
		$dt = $obj;
		$x = is_array($n)? $n : explode('.', $n);
		$c = count($x);		
		
		foreach($x as $k => $v)
		{
			if(isset($dt[$v]))
			{
				if($k == $c-1)
					return $dt[$v];
				else
					$dt = $dt[$v] ;
			}
			else
				return $def;
		}
	}
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	
	public static function geta($obj, $k, $def = false, $def_empty = array(-1))
	{
		if(array_key_exists($k, $obj))
		{
			if(count($obj[$k]) == 0)
				return $def_empty;
			else if(count($obj[$k]) == 1 && $obj[$k] == '')
				return $def_empty;
			else
				return $obj[$k];
		}
		else
			return $def;
	}		
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	
	public static function get_by_keys($arr, $keys, $get_sort_keys = false)
	{
		$ret = array();

		if($get_sort_keys)
		{
			foreach($keys as $v)
			{
				if(array_key_exists($v, $arr))
					$ret[$v] = $arr[$v];
			}
		}
		else
		{
			foreach($arr as $k => $v)
			{
				if(in_array($k, $keys))
					$ret[$k] = $v;
			}
		}

		return $ret;
	}
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	
	public static function get_by_values($arr, $n, $val)
	{
		$ret = array();

		if(!is_array($val))
			$val = array($val);
		
		foreach($arr as $k => $v)
		{
			if(in_array($v[$n], $val))
				$ret[$k] = $v;
		}
		
		return $ret;
	}	
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	public static function mk_recurrent($o, $kn='grupa', $vn='id', $en='items', $key = 0)
	{
		$no = array();
		foreach($o as $k => $v)
		{
			if($v[$kn] == $key)
			{
				$v[$en] = array();
				$v[$en] = arr :: mk_recurrent($o, $kn, $vn, $en, $v[$vn]);
				$no[$k] = $v;
			}
		}

		return $no;
	}

	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	public static function recurrent($arr, $k, $x=0)
	{
		return self :: recurrent_x($arr, $k, $x, true);
	}

	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	public static function recurrent_x($r, $k, $x = 0, $reset = false)
	{
		static $n = array(), $pos = -1;
		
		if($reset)
			$n = array();

		for($i=0; $i<count($r); $i++)
		{
			if($r[$i][$k] == $x)
			{
				$pos ++;
				$r[$i]['recurrent_position'] = $pos;
				$n[] = $r[$i];
				$n = self :: recurrent_x($r, $k, $r[$i]['id']);
				$pos--;
			}
		}
		return $n;
	}

	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	public static function del_empty($arr)
	{
		$n = array();
		foreach($arr as $k => $v)
		{
			if((is_array($v) && count($v) > 0) || (!is_array($v) && $v > ""))
				$n[$k] = $v;
		}

		return $n;
	}

	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	public static function recposition($arr, $key, $i=1, $zn = "&nbsp;")
	{
		$n = array();
		foreach($arr as $k => $v)
		{
			$v[$key] = str_repeat($zn, $v['recurrent_position']*$i).$v[$key];
			$n[$k] = $v;
		}
		
		return $n;
	}
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	
	public static function numerate($arr, $zn = ".")
	{
		$lp = 0;
		$fix = array(0);
		foreach($arr as $k => $v)
		{
			$rp = $v["recurrent_position"];
			
			if($rp > $lp)
				array_push($fix, 1);
			if($rp == $lp)
				$fix[count($fix)-1]++;
			if($rp < $lp)
			{
				array_pop($fix);
				$fix[count($fix)-1]++;
			}
		
			$arr[$k]["recurrent_number"] = $fix;
			$lp = $v["recurrent_position"];
		}

		foreach($arr as $k => $v)
			$arr[$k]["recurrent_number"] = join($zn, $v["recurrent_number"]);

		return $arr;
	}

	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	public static function get_road($obj, $x, $n1 = 'id', $n2 = 'grupa', $ret = array())
	{
		foreach($obj as $v)
		{
			if($v[$n1] == $x)
			{
				$ret[] = $v;
				return ($v[$n2] == 0)? $ret : self :: get_road($obj, $v[$n2], $n1, $n2, $ret);
			}
		}
		return $ret;
	}	
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	public static function rm_keys($arr, $keys)
	{
		$n = array();

		if(!is_array($keys))
			$keys = array($keys);

		foreach($arr as $k => $v)
		{
			if(!in_array($k, $keys))
				$n[$k] = $v;
		}

		return $n;
	}

	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	//usuwa wpisy z tablicy zachowuj1c przypisanie z kluczami jezeli wartosc jest rowna drugiemu parametrowi
	//je?eli $one = true usunie tylko pierwsza znaleziona wartosc
	
	public static function rm_values($arr, $values, $one=false)
	{
		$n = array();

		$used = array();

		if(!is_array($values))
			$values = array($values);
				
		foreach($arr as $k => $v)
		{
			if(!in_array($v, $values) || in_array($v, $used))
			{
				$n[$k] = $v;
			}
			else
			{
				if($one)
					$used[] = $v;
			}
		}

		return $n;
	}
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	//usuwa wpisy z tablicy wielopoziomowej zachowuj1c przypisanie z kluczami jezeli wartosc jest rowna drugiemu parametrowi
	//je?eli $one = true usunie tylko pierwsza znaleziona wartosc	

	public static function rm_values_n($arr, $n, $values, $one=false)
	{
		$ret = array();

		$used = array();

		if(!is_array($values))
			$values = array($values);
				
		foreach($arr as $k => $v)
		{
			if(!in_array($v[$n], $values) || in_array($v[$n], $used))
				$ret[$k] = $v;
			else
			{
				if($one)
					$used[] = $v;
			}
		}

		return $ret;
	}	
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	
	public static function join_arr($arr, $key, $sep = ',')
	{
		$x = array();

		foreach($arr as $v)
			$x[] = $v[$key];
		
		return join($x, $sep);
	}
	
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	
	public static function pos_by_keys($arr, $posa)
	{
		$n = array();
		$u = array();
		
		foreach($posa as $ps)
		{
			if(array_key_exists($ps, $arr))
			{
				$n[$ps] = $arr[$ps];
				$u[] = $ps;
			}
		}
		
		foreach($arr as $k => $v)
		{
			if(!in_array($k, $u))
				$n[$k] = $v;
		}

		return $n;
	}
}

?>