<?php

$cf = new configuration(CONFIGURATION_FILE);

switch($B)
{
	case 'get_img':
	case 'get_image':
	case 'save_image':
	case 'save_img':

		$camName = $C > ''? $C : '' ;
		
		$objList = $cf -> get('cameras');
		$camObj = null;

		foreach($objList as $v)
		{
			if($v['nazwa'] == $camName){
				$camObj = $v;
			}
		}
		
		$err = null;
		$output = null;
		$is_base = $IS_ARGV == true || http :: _get('b64')==1;

		if($camObj)
		{
			list($is, $output) = imgCam :: getImage($camObj);

			if($is)
			{
				$crop = arr :: get($camObj, 'crop');

				if($crop){
					if($crop['x'] > '' && $crop['y'] > '' && $crop['w'] > '' && $crop['h'] > '')
						$output = imgCam :: crop($output, $crop);
				}
			}
			else
				$err = array('Blad pobierania obrazu', $output);
		}
		else
			$err = array('Blad konfiguracji', 'brak: ' . $camName);

		if($is_base){
			ob_start();

			if($err)
				imgCam :: dispError($err, '', false);
			else
				imgCam :: disp($output, false);
			
			$contents = ob_get_contents();
			ob_end_clean();
			$dataUri = 'data:image/jpeg;base64,' . base64_encode($contents);

			if($B == 'save_image' || $B == 'save_img')
				file_put_contents(ROOT_DIR . "data/cam_images/" . $camObj['nazwa'] . ".jpg", $contents);

			exit($dataUri);
		}
		else{
			if($err)
				imgCam :: dispError($err);
			else
				imgCam :: disp($output);
		}

	break;

}

class imgCam{
	
	public static $quality = 65;

	public static function disp($str, $header = true){
		
		if($header)
			header ('Content-type: image/jpg');
		
		if(gettype($str) == 'string')
			exit($str);
		else
			imagejpeg($str, null, self :: $quality);

	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function dispError($str1, $str2 = '', $header = true){
		
		if($header)
			header ('Content-type: image/jpg');

		if(is_array($str1))
			list($str1, $str2) = array($str1[0], isset($str1[1])? $str1[1] : '' );
		
		imagejpeg(self :: imError($str1, $str2), null, 90);		
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function imError($str, $strE = '')
	{
		$w = 300;
		$im = imagecreate($w, 200);
		$bg = imagecolorallocate($im, 20, 20, 20);
		$textcolor = imagecolorallocate($im, 250, 200, 200);

		$x = function($w, $str, $fs){
			return $w/2 - (strlen($str)/2)*($fs+4);
		};

		imagestring($im, 5, $x($w, $str, 5), 50, $str, $textcolor);	

		if($strE > '')
			imagestring($im, 3, $x($w, $str, 3), 100, $strE, $textcolor);	
		
		return $im;
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function getImage($obj)
	{
		if($obj['access'] && isset($obj['access']['login']) && isset($obj['access']['passwd']) && ($obj['access']['login'] > '' && $obj['access']['passwd'] > ''))
			return curl :: image($obj['url'], 5, array('login' => $obj['access']['login'], 'passwd' => $obj['access']['passwd']));
		else
			return curl :: image($obj['url'], 5);
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function crop($strImg, $cropObj)
	{
		$c_x = arr :: get($cropObj, 'x', 25);
		$c_y = arr :: get($cropObj, 'y', 25);
		$c_w = arr :: get($cropObj, 'w', 75);
		$c_h = arr :: get($cropObj, 'h', 75);
		$c_k = (integer)arr :: get($cropObj, 'r', 0);

		//$im = gettype($strImg) == 'string'? self :: _resFromStr($strImg) : $strImg ;
			//	exit(gettype($im));
		try {
			$im = @imagecreatefromstring($strImg);
			
			if($im !== false)
			{
				$w  = imagesx($im);
				$h = imagesy($im);
				
				if($c_k != 0){
					$bgc = imagecolorallocate($im, 100, 100, 100);				
					$im = imagerotate($im, -$c_k, $bgc);
				}

				$im = imagecrop($im, array('x' => $w * $c_x/100, 'y' => $h *$c_y/100, 'width' => $w * $c_w/100, 'height' => $h * $c_h/100));

				return $im;
			}
			
		} catch (Exception $e) {
			
		}
		
		return $strImg;		
	}
	
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	
	private static function _resFromStr($str)
	{
		//$f = sys_get_temp_dir() . '/' . uniqid() . '.jpg';
		//file_put_contents($f, $str);		
		//header ('Content-type: image/jpg');
		//exit(file_get_contents($f));
		//exit(ini_get('memory_get_usage'));
		$im = imagecreatefromjpeg($f);
		unlink($f);		
		die;
		return $im;
	}
}

?>