<?php

class html
{
	public static function table($obj, $opt = array())
	{
		$rows = [];

		foreach($obj as $k => $v)
		{
			$rows[] = '<tr><td>'.$k.'</td><td>'.$v.'</td></tr>';
		}
		return '<table class="'.arr :: get($opt, 'class', 'table').'">'.join('', $rows).'</table>';
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	
	public static function tbl($obj, $opt = array())	
	{
		$s = '<div class="'.arr :: get($opt, 'class', 'tbl').'">';
		$repl = arr :: get($opt, 'replace', array());
		$only_val = arr :: get($opt, 'only_val');
		
		foreach($obj as $k => $v)	
		{
			if(is_array($v))
				$val = '-array-';
			else if($v > '' && array_key_exists($v.'', $repl))
				$val = $repl[$v];
			else
				$val = $v;

			if($only_val)
				$s .= '<div class="tr"><div class="td">'.$val.'</div></div>' . "\n";
			else
				$s .= '<div class="tr"><div class="td">'.(is_array($k)? '-array-' : $k).'</div><div class="td">'.$val.'</div></div>' . "\n";
		}

		$s .= '</div>';

		return $s;		
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	
	public static function tbl_full($obj, $header = [], $opt = array())	
	{
		$s = '<table class="list1">';
		$repl = arr :: get($opt, 'replace', array());
		$only_val = arr :: get($opt, 'only_val');

		if(is_array($header)){
			$s .= '<thead><tr>';
			foreach($header as $v)
				$s .= '<td>'.$v.'</td>';
			$s .= '</tr></thead>';
		}
		$s .= '<tbody>';
		foreach($obj as $k => $v)	
		{
			$s .= '<tr>';
			foreach($header as $e => $h)
				$s .= '<td>'.arr :: get($v, $e, '---').'</td>';	
			$s .= '</tr>';
		}
		
		$s .= '</tbody>';
		$s .= '</table>';

		return $s;		
	}	
	
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function template_get($n, $confObj = array())
	{
		$obj = configuration :: getTemplates($confObj);
		return arr :: get($obj, $n, array());
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function mk_elem($conf)
	{
		//$elemDisp = configuration :: getElementsDesc('start');
		$elemDisp = modules :: get_start_elem();

		$s = '<div id="menuZakContainer"></div>';
		$s .= '<div>';
		
		foreach($elemDisp as $k => $v)
		{
			$_e = arr :: get($conf, $k, array());
			$s .= self :: mk_elem_opt($k, $_e, $v['name'], $v['ico']);//, $v['desc']
			//$s .= $v['name'] . '<br><br>';
		}

		$s .= '</div>';		
		$s .= '<script type="text/javascript">

		$(function(){
			rpih.read_all();
		});	
		
		</script>';		

		return $s;
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function mk_ic($ic, $is_min = false)
	{
		if($ic > '')
		{
			if(strpos($ic, '.png') > 0)
				return '<span class="module_ico mgr-10"><img src="'.$ic.'" alt="" title=""></span>';
			else
				return '<span class="module_ico '.($is_min? 'min' : '').' mgr-10"><i class="fa '.$ic.'" aria-hidden="true"></i></span>';		
		}
			else return '';
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function mk_elem_opt($t, $obj, $n = false, $ic = '', $desc='')
	{
		$s = '';

		if($n)
		{
			$linkEdit = configuration :: isValidElement($t)? '<a href="?a=form_edit&b='.$t.'" class="link c-white">edytuj</a>' : '' ;

			//$ic = $ic? '<span style="width:40px;" class="ib center"><i class="fa '.$ic.'" aria-hidden="true"></i></span>' : '';
			$ic = self :: mk_ic($ic);
			//$s .= '<div class="tbl full emNag"><div class="td" style="width:30%;">'.$ic.'<h3>'.$n.'</h3></div><div class="td l pdr-10">';
			//$s .= '<div class="tbl full"><div class="td l m c-white f-min">'.$desc.'</div><div class="td r">'.$linkEdit.'</div></div>';
			//$s .= '</div></div>';
		}

		$ident2height = md5($n);
		
		if(count($obj) > 0)
		{
			$s .= '<div class="elem six mgt-5 mgb-20">';

			$s .= '<div class="em emFields zazn">
				<div data-css-all-h="elem_ster_1_'.$ident2height.'">
					<div class="tbl"><div class="td m pdt-5 f-plus">'.$ic.'</div><div class="td m"><h3>'.$n.'</h3></div></div>		
					<div class="f-min">'.$desc.'</div>
				</div>
				<div data-css-all-h="elem_ster_2_'.$ident2height.'" class="right">
					'.$linkEdit.'
				</div>
			</div>';


			foreach($obj as $v)
			{
				$name = $v['nazwa'];

				if(!isset($v['typ']))
					$v['typ'] = '';

				if($t == 'variables')
				{
					if($v['typ'] == 'yn')
						$click = '<a href="#" class="elemPanelBtn" onclick="rpih.elemSetToggle(\''.$name.'\'); return false;">tak/nie</a>';
					else if($v['typ'] == 'counter')
					{
						$click = '<a href="#" class="elemPanelBtn" onclick="rpih.elemSetAction(\''.$name.'\', 0, 1); return false;">reset</a>';
						$click .= '<a href="#" class="elemPanelBtn" onclick="rpih.elemSetAction(\''.$name.'\', prompt(\'Wartość\')); return false;">dodaj</a>';
					}
					else if($v['typ'] == 'text')
						$click = '<a href="#" class="elemPanelBtn" onclick="rpih.elemSetAction(\''.$name.'\', prompt(\'Wartość\'), \'~\'); return false;">ustaw</a>';
					else
						$click = '<a href="#" class="elemPanelBtn" onclick="rpih.elemSetAction(\''.$name.'\', prompt(\'Wartość\')); return false;">ustaw</a>';
				}
				else if($t == 'ports' || $t == 'i2c')
				{
					if($v['typ'] == 'element')
						$click = '';
					else
						$click = '<a href="#" class="elemPanelBtn" onclick="rpih.elemSetAction(\''.$name.'\', prompt(\'Komenda\')); return false;">wyślij</a>';
				}
				else if($t == 'rs485')
				{
					if($v['typ'] == 'definicja')
						$click = '<a href="#" class="elemPanelBtn" onclick="rpih.elemSetAction(\''.$name.'\', prompt(\'Komenda\')); return false;">wyślij</a>';
					else if($v['typ'] == 'element')
					{
						$click = '<a href="#" class="elemPanelBtn" onclick="rpih.elemSetAction(\''.$name.'\', prompt(\'Komenda\')); return false;">wyślij</a>';
						$click .= '<a href="#" class="elemPanelBtn" onclick="rpih.elemSetToggle(\''.$name.'\'); return false;">przełącz</a>';
					}
					else
						$click = '';
				}
				else if($t == 'rflink')
				{
					$cmds = explode(';', $v['komendy']);
					$click = [];

					foreach($cmds as $c)
						$click[] = '<a href="#" class="elemPanelBtn" onclick="rpih.elemSetAction(\''.$name.'\', \''.$c.'\'); return false;">'.$c.'</a>';

					$click = join(' ', $click);
				}
				else if($t == 'events' || $t == 'time' || $t == 'tasks')
				{
					$click = '<a href="#" class="elemPanelBtn" onclick="rpih.elemSetAction(\''.$name.'\', 1); return false;">uruchom</a>';
				}
				else if($t == 'zigbee')
				{
					if($v['typ'] == 'pk')
						$click = '<a href="#" class="elemPanelBtn" onclick="rpih.elemSetToggle(\''.$name.'\'); return false;">on/off</a>';
					else if($v['typ'] == 'sensor')
						$click = '<a href="#" class="elemPanelBtn" onclick="rpih.elemSetAction(\''.$name.'\', prompt(\'Wartość\'), \'~\'); return false;">ustaw</a>';

				}
				else if($v['typ'] == 'out_d_0')
					$click = '<a href="#" class="elemPanelBtn" onclick="rpih.elemSetToggle(\''.$name.'\'); return false;">on/off</a>';
				else if($v['typ'] == 'pwm')
				{
					$click = '<a href="#" class="elemPanelBtn" onclick="rpih.elemPwm(\''.$name.'\', \'toggle\'); return false;">on/off</a>';
					$click .= ' ';
					$click .= '<a href="#" class="elemPanelBtn" onclick="rpih.elemPwm(\''.$name.'\', \'fill\', prompt(\'Wypełnienie\'));  return false;">wyp</a>';
				}
				else if($v['typ'] == 'afe_1ch' || $v['typ'] == 'afe_1ch_v3')
					$click = '<a href="#" class="elemPanelBtn" onclick="rpih.elemSetToggle(\''.$name.'\'); return false;">tak/nie</a>';
				else if($v['typ'] == 'comp')
					$click = '<a href="#" class="elemPanelBtn" onclick="rpih.elemSetToggle(\''.$name.'\'); return false;">tak/nie</a>';
				else if($t == 'cameras')
				{
					$click = '<a href="#" class="elemPanelBtn" onclick="rpih.elemSetAction(\''.$name.'\', -1); return false;">zapisz w data/cam_images/</a>';
					$click .= '<br><a href="#" class="elemPanelBtn" onclick="rpih.elemCamImage(\''.$name.'\'); return false;">pokaż</a>';
				}
				else if($v['typ'] == 'lk2' || $v['typ'] == 'lk3' || $v['typ'] == 'arduino-v1')
				{
					$fields = explode(';', $v['param']);
					$click = '<div class="flexList flexMin">';
					
					foreach($fields as $pp)
					{
						$click .= '<div class="flexItem">';
						$_pp = explode('=', $pp);
						if(count($_pp) > 1)
						{
							$_ns = $name . '.' . $_pp[0];
							$_nv = '<span title="' . ($_pp[0] . ' > ' . $_pp[1]) . '">' . $_pp[0] . '</span>';
						}
						else
						{
							$_ns = $name . '.' . $pp;
							$_nv = $pp;							
						}
						
						$_blink_gw = '<span class="setChange" style="color:transparent;" data-ident-res-blink="'.$_ns.'"><i class="fa fa-star" aria-hidden="true"></i></span>';
						$_res = '<span data-ident-res="'.$_ns.'" data-ident-type="">...</span>';
						$click .= '<span class="elemPanelBtn" onclick="rpih.elemSetToggle(\''.$_ns.'\'); return false;"><span class="f-min nw">'.$_nv.'</span><br>'.$_res.''.$_blink_gw.'</span>';
						


						$click .= '</div>';
					}

					$click .= '</div>';
				}
				else
					$click = '<a href="#" onclick="return false;">&nbsp;</a>';

				if($t == 'devices' || $t == 'cameras' || $t == 'rs485' || $t == 'i2c' || $t == 'events' || $t == 'time' || $t == 'tasks' || $t == 'script')
				{
					$is_active = isset($v['aktywny']) && $v['aktywny']==1;
					$activeLink = 'index.php?a=data_actions&action=elements_set_active&type='.$t.'&name='.$v['nazwa'];					
					$activeLink = '<span class="ch_active" onclick="page.sendQuery(\''.$activeLink.'\');"><span class="'.($is_active? 'now_0' : 'now_1').'">on</span>/<span class="'.($is_active? 'now_1' : 'now_0').'">off</span></span>';	
				}
				else
				{
					$is_active = true;
					$activeLink = '';
				}

				$s .= '<div class="em">
							<div class="emFields '.($is_active? '' : 'inactive').' rel">
								<div data-css-all-h="elem_ster_1_'.$ident2height.'">
									'.($v['opis'] > '' ?'<div style="min-height:10px;">'.$v['opis'].'</div>' : '').'
									<div>
										<div class="tbl full"><div class="td l t name" style="">'.$v['nazwa'].'</div><div class="td r t">'.$activeLink.'</div></div>
									</div>
									'.($t != 'devicesfsdfsf'? '<div class="mgt-5 value" data-ident-res="'.$name.'" data-ident-type="'.(isset($v['typ'])? $v['typ'] : $t).'">...</div>' : '').'
								</div>
								<div data-css-all-h="elem_ster_2_'.$ident2height.'">
									<div class="right">'.$click.'</div>
								</div>
								<div class="abs-right-top mgt-5 mgr-5 setChange" style="color:transparent;" data-ident-res-blink="'.$name.'"><i class="fa fa-star" aria-hidden="true"></i></div>
							</div>							
						</div>';
			}

			$s .= '</div>';
		}
		else
		{
			//$s .= '<div class="mgt-5 mgb-10">--brak elementów---</div>';
		}

		return $s;
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	
	public static function header($n = false, $dot_elem = array())
	{
		return html_header :: get($n, $dot_elem);
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	
	public static function footer()
	{
		$s = '';

		$s .= '<div id="panelLockDv"></div>';
		
		$s .= '</div></section>';

		//$s = '<div data-css-set="height,as_div_height,footer">&nbsp;</div>';

		$s .= '<footer><div class="max_page_width">
		<div class="tbl full">
			<div class="td m">Strona projektu: <a href="'.PROJECT_SITE_URL.'" target="_blank" style="color:#aaa;">'.PROJECT_SITE_URL.'</a></div>
			<div class="td r m">Ostatnia aktualizacja: '.(defined('UPDATE_DATE')? UPDATE_DATE : '--brak-danych--').'</div>
		</div>
		</div>
		</footer>';

		return $s . '</div></div></body></html>';
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function msg($msg)
	{
		$s = self :: header();

		$s .= '<div class="center mgt-20 mgb-20">' . $msg . '</div>';

		$s .= self :: footer();

		return $s;
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public static function tpl($file, $obj = [])
	{
		if(file_exists($file))
		{
			$s = file_get_contents($file);

			$replaceObj = array(
				'files%' => 'src/files/'
			);

			$s = str_replace(array_keys($replaceObj), array_values($replaceObj), $s);

			$rpl = [];

			foreach($obj as $k => $v)
				$rpl['{$'.$k.'}'] = $v;

			$s = str_replace(array_keys($rpl), array_values($rpl), $s);

			return $s;
		}
		else
			return 'TPL - Nie mozna odnaleźć pliku: '.basename($file).'';
	}

}

?>